/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.jobexecutor;

import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.bpmn.behavior.BoundaryEventActivityBehavior;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.jobexecutor.JobHandler;
import org.activiti.engine.impl.jobexecutor.TimerEventHandler;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.delegate.ActivityBehavior;
import org.flowable.job.api.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerExecuteNestedActivityJobHandler
extends TimerEventHandler
implements JobHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimerExecuteNestedActivityJobHandler.class);
    public static final String TYPE = "timer-transition";
    public static final String PROPERTYNAME_TIMER_ACTIVITY_ID = "activityId";
    public static final String PROPERTYNAME_END_DATE_EXPRESSION = "timerEndDate";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void execute(Job job, String configuration, ExecutionEntity execution, CommandContext commandContext) {
        String nestedActivityId = TimerEventHandler.getActivityIdFromConfiguration(configuration);
        ActivityImpl borderEventActivity = execution.getProcessDefinition().findActivity(nestedActivityId);
        if (borderEventActivity == null) {
            throw new ActivitiException("Error while firing timer: border event activity " + nestedActivityId + " not found");
        }
        try {
            if (commandContext.getEventDispatcher().isEnabled()) {
                commandContext.getEventDispatcher().dispatchEvent((FlowableEvent)ActivitiEventBuilder.createEntityEvent(FlowableEngineEventType.TIMER_FIRED, job), "cfg.processEngine");
                this.dispatchActivityTimeoutIfNeeded(job, execution, commandContext);
            }
            borderEventActivity.getActivityBehavior().execute((DelegateExecution)execution);
        }
        catch (RuntimeException e) {
            LOGGER.error("exception during timer execution", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("exception during timer execution", (Throwable)e);
            throw new ActivitiException("exception during timer execution: " + e.getMessage(), e);
        }
    }

    protected void dispatchActivityTimeoutIfNeeded(Job timerEntity, ExecutionEntity execution, CommandContext commandContext) {
        BoundaryEventActivityBehavior boundaryEventActivityBehavior;
        String nestedActivityId = TimerEventHandler.getActivityIdFromConfiguration(timerEntity.getJobHandlerConfiguration());
        ActivityImpl boundaryEventActivity = execution.getProcessDefinition().findActivity(nestedActivityId);
        ActivityBehavior boundaryActivityBehavior = boundaryEventActivity.getActivityBehavior();
        if (boundaryActivityBehavior instanceof BoundaryEventActivityBehavior && (boundaryEventActivityBehavior = (BoundaryEventActivityBehavior)boundaryActivityBehavior).isInterrupting()) {
            this.dispatchExecutionTimeOut(timerEntity, execution, commandContext);
        }
    }

    protected void dispatchExecutionTimeOut(Job job, ExecutionEntity execution, CommandContext commandContext) {
        ActivityImpl activity;
        for (ExecutionEntity subExecution : execution.getExecutions()) {
            this.dispatchExecutionTimeOut(job, subExecution, commandContext);
        }
        ExecutionEntity subProcessInstance = commandContext.getExecutionEntityManager().findSubProcessInstanceBySuperExecutionId(execution.getId());
        if (subProcessInstance != null) {
            this.dispatchExecutionTimeOut(job, subProcessInstance, commandContext);
        }
        if ((activity = execution.getActivity()) != null && activity.getActivityBehavior() != null) {
            this.dispatchActivityTimeOut(job, activity, execution, commandContext);
        }
    }

    protected void dispatchActivityTimeOut(Job job, ActivityImpl activity, ExecutionEntity execution, CommandContext commandContext) {
        commandContext.getEventDispatcher().dispatchEvent((FlowableEvent)ActivitiEventBuilder.createActivityCancelledEvent(activity.getId(), (String)activity.getProperties().get("name"), execution.getId(), execution.getProcessInstanceId(), execution.getProcessDefinitionId(), (String)activity.getProperties().get("type"), activity.getActivityBehavior().getClass().getCanonicalName(), job), "cfg.processEngine");
    }
}

