/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.jobexecutor;

import java.util.List;
import org.activiti.engine.impl.bpmn.helper.ErrorPropagation;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.jobexecutor.JobHandler;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntityManager;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.flowable.job.api.Job;

public class ExternalWorkerTaskCompleteJobHandler
implements JobHandler {
    public static final String TYPE = "external-worker-complete";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void execute(Job job, String configuration, ExecutionEntity execution, CommandContext commandContext) {
        VariableInstanceEntityManager variableInstanceEntityManager = commandContext.getVariableInstanceEntityManager();
        List<VariableInstanceEntity> jobVariables = variableInstanceEntityManager.findVariableInstancesBySubScopeIdAndScopeType(execution.getId(), "bpmnExternalWorker");
        for (VariableInstanceEntity jobVariable : jobVariables) {
            execution.setVariable(jobVariable.getName(), jobVariable.getValue());
            variableInstanceEntityManager.delete(jobVariable);
        }
        if (configuration != null && configuration.startsWith("error:")) {
            String errorCode = configuration.length() > 6 ? configuration.substring(6) : null;
            ErrorPropagation.propagateError(errorCode, (ActivityExecution)execution);
        } else {
            execution.signal(null, null);
        }
    }
}

