/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.interceptor;

import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandConfig;
import org.activiti.engine.impl.interceptor.RetryInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JtaRetryInterceptor
extends RetryInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JtaRetryInterceptor.class);
    protected final TransactionManager transactionManager;

    public JtaRetryInterceptor(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public <T> T execute(CommandConfig config, Command<T> command) {
        if (this.calledInsideTransaction()) {
            LOGGER.trace("Called inside transaction, skipping the retry interceptor.");
            return this.next.execute(config, command);
        }
        return super.execute(config, command);
    }

    protected boolean calledInsideTransaction() {
        try {
            return this.transactionManager.getStatus() != 6;
        }
        catch (SystemException e) {
            throw new ActivitiException("Could not determine the current status of the transaction manager: " + e.getMessage(), e);
        }
    }
}

