/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.JobNotFoundException;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.cfg.TransactionState;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.jobexecutor.FailedJobListener;
import org.activiti.engine.impl.jobexecutor.JobExecutorContext;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteJobsCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecuteJobsCmd.class);
    protected String jobId;
    protected JobEntity job;

    public ExecuteJobsCmd(String jobId) {
        this.jobId = jobId;
    }

    public ExecuteJobsCmd(JobEntity job) {
        this.job = job;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        JobExecutorContext jobExecutorContext;
        if (this.jobId == null && this.job == null) {
            throw new ActivitiIllegalArgumentException("jobId and job is null");
        }
        if (this.job == null) {
            this.job = commandContext.getJobEntityManager().findJobById(this.jobId);
        }
        if (this.job == null) {
            throw new JobNotFoundException(this.jobId);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing job {}", (Object)this.job.getId());
        }
        if ((jobExecutorContext = Context.getJobExecutorContext()) != null) {
            jobExecutorContext.setCurrentJob(this.job);
        }
        FailedJobListener failedJobListener = null;
        try {
            failedJobListener = new FailedJobListener(commandContext.getProcessEngineConfiguration().getCommandExecutor(), this.job.getId());
            commandContext.getTransactionContext().addTransactionListener(TransactionState.ROLLED_BACK, failedJobListener);
            this.job.execute(commandContext);
            if (commandContext.getEventDispatcher().isEnabled()) {
                commandContext.getEventDispatcher().dispatchEvent((FlowableEvent)ActivitiEventBuilder.createEntityEvent(FlowableEngineEventType.JOB_EXECUTION_SUCCESS, this.job), "cfg.processEngine");
            }
        }
        catch (Throwable exception) {
            failedJobListener.setException(exception);
            if (commandContext.getEventDispatcher().isEnabled()) {
                try {
                    commandContext.getEventDispatcher().dispatchEvent((FlowableEvent)ActivitiEventBuilder.createEntityExceptionEvent(FlowableEngineEventType.JOB_EXECUTION_FAILURE, this.job, exception), "cfg.processEngine");
                }
                catch (Throwable ignore) {
                    LOGGER.warn("Exception occurred while dispatching job failure event, ignoring.", ignore);
                }
            }
            if (!(exception instanceof ActivitiException)) {
                throw new ActivitiException("Job " + this.jobId + " failed", exception);
            }
            throw (ActivitiException)exception;
        }
        finally {
            if (jobExecutorContext != null) {
                jobExecutorContext.setCurrentJob(null);
            }
        }
        return null;
    }

    public String getJobId() {
        return this.jobId;
    }
}

