/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteAsyncJobCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecuteAsyncJobCmd.class);
    protected JobEntity job;

    public ExecuteAsyncJobCmd(JobEntity job) {
        this.job = job;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        if (this.job == null) {
            throw new ActivitiIllegalArgumentException("job is null");
        }
        JobEntity refetchedJob = commandContext.getJobEntityManager().findJobById(this.job.getId());
        if (refetchedJob == null) {
            LOGGER.debug("Job does not exist anymore and will not be executed. It has most likely been deleted as part of another concurrent part of the process instance.");
            return null;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing async job {}", (Object)refetchedJob.getId());
        }
        refetchedJob.execute(commandContext);
        if (commandContext.getEventDispatcher().isEnabled()) {
            commandContext.getEventDispatcher().dispatchEvent((FlowableEvent)ActivitiEventBuilder.createEntityEvent(FlowableEngineEventType.JOB_EXECUTION_SUCCESS, refetchedJob), "cfg.processEngine");
        }
        return null;
    }
}

