/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cfg;

import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import org.activiti.engine.ProcessEngineConfiguration;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.cfg.SpringBeanFactoryProxyMap;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class BeansConfigurationHelper {
    public static ProcessEngineConfiguration parseProcessEngineConfiguration(Resource springResource, String beanName) {
        DefaultListableBeanFactory beanFactory = new DefaultListableBeanFactory();
        XmlBeanDefinitionReader xmlBeanDefinitionReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)beanFactory);
        xmlBeanDefinitionReader.setValidationMode(3);
        xmlBeanDefinitionReader.loadBeanDefinitions(springResource);
        Collection factoryPostProcessors = beanFactory.getBeansOfType(BeanFactoryPostProcessor.class, true, false).values();
        if (factoryPostProcessors.isEmpty()) {
            factoryPostProcessors = Collections.singleton(new PropertyPlaceholderConfigurer());
        }
        for (BeanFactoryPostProcessor factoryPostProcessor : factoryPostProcessors) {
            factoryPostProcessor.postProcessBeanFactory((ConfigurableListableBeanFactory)beanFactory);
        }
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)beanFactory.getBean(beanName);
        processEngineConfiguration.setBeans(new SpringBeanFactoryProxyMap((BeanFactory)beanFactory));
        return processEngineConfiguration;
    }

    public static ProcessEngineConfiguration parseProcessEngineConfigurationFromInputStream(InputStream inputStream, String beanName) {
        InputStreamResource springResource = new InputStreamResource(inputStream);
        return BeansConfigurationHelper.parseProcessEngineConfiguration((Resource)springResource, beanName);
    }

    public static ProcessEngineConfiguration parseProcessEngineConfigurationFromResource(String resource, String beanName) {
        ClassPathResource springResource = new ClassPathResource(resource);
        return BeansConfigurationHelper.parseProcessEngineConfiguration((Resource)springResource, beanName);
    }
}

