/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.bpmn.behavior.EventSubProcessStartEventActivityBehavior;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractActivityBpmnParseHandler;
import org.activiti.engine.impl.form.DefaultStartFormHandler;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.ScopeImpl;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.ErrorEventDefinition;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.MessageEventDefinition;
import org.flowable.bpmn.model.SignalEventDefinition;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.TimerEventDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartEventParseHandler
extends AbstractActivityBpmnParseHandler<StartEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StartEventParseHandler.class);
    public static final String PROPERTYNAME_INITIATOR_VARIABLE_NAME = "initiatorVariableName";
    public static final String PROPERTYNAME_INITIAL = "initial";

    @Override
    public Class<? extends BaseElement> getHandledType() {
        return StartEvent.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, StartEvent startEvent) {
        ActivityImpl startEventActivity = this.createActivityOnCurrentScope(bpmnParse, (FlowElement)startEvent, "startEvent");
        ScopeImpl scope = bpmnParse.getCurrentScope();
        if (scope instanceof ProcessDefinitionEntity) {
            this.createProcessDefinitionStartEvent(bpmnParse, startEventActivity, startEvent, (ProcessDefinitionEntity)scope);
            this.selectInitial(bpmnParse, startEventActivity, startEvent, (ProcessDefinitionEntity)scope);
            this.createStartFormHandlers(bpmnParse, startEvent, (ProcessDefinitionEntity)scope);
        } else {
            this.createScopeStartEvent(bpmnParse, startEventActivity, startEvent);
        }
    }

    protected void selectInitial(BpmnParse bpmnParse, ActivityImpl startEventActivity, StartEvent startEvent, ProcessDefinitionEntity processDefinition) {
        if (processDefinition.getInitial() == null) {
            processDefinition.setInitial(startEventActivity);
        } else if (!(startEventActivity.getProperty("type").equals("messageStartEvent") || startEventActivity.getProperty("type").equals("signalStartEvent") || startEventActivity.getProperty("type").equals("startTimerEvent"))) {
            String currentInitialType = (String)processDefinition.getInitial().getProperty("type");
            if ("messageStartEvent".equals(currentInitialType)) {
                processDefinition.setInitial(startEventActivity);
            } else {
                throw new ActivitiException("multiple none start events or timer start events not supported on process definition");
            }
        }
    }

    protected void createStartFormHandlers(BpmnParse bpmnParse, StartEvent startEvent, ProcessDefinitionEntity processDefinition) {
        if (processDefinition.getInitial() != null && startEvent.getId().equals(processDefinition.getInitial().getId())) {
            DefaultStartFormHandler startFormHandler = new DefaultStartFormHandler();
            startFormHandler.parseConfiguration(startEvent.getFormProperties(), startEvent.getFormKey(), bpmnParse.getDeployment(), processDefinition);
            processDefinition.setStartFormHandler(startFormHandler);
        }
    }

    protected void createProcessDefinitionStartEvent(BpmnParse bpmnParse, ActivityImpl startEventActivity, StartEvent startEvent, ProcessDefinitionEntity processDefinition) {
        if (StringUtils.isNotEmpty((CharSequence)startEvent.getInitiator())) {
            processDefinition.setProperty(PROPERTYNAME_INITIATOR_VARIABLE_NAME, startEvent.getInitiator());
        }
        startEventActivity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createNoneStartEventActivityBehavior(startEvent));
        if (!startEvent.getEventDefinitions().isEmpty()) {
            EventDefinition eventDefinition = (EventDefinition)startEvent.getEventDefinitions().get(0);
            if (eventDefinition instanceof TimerEventDefinition || eventDefinition instanceof MessageEventDefinition || eventDefinition instanceof SignalEventDefinition) {
                bpmnParse.getBpmnParserHandlers().parseElement(bpmnParse, (BaseElement)eventDefinition);
            } else {
                LOGGER.warn("Unsupported event definition on start event {}", (Object)eventDefinition);
            }
        }
    }

    protected void createScopeStartEvent(BpmnParse bpmnParse, ActivityImpl startEventActivity, StartEvent startEvent) {
        boolean isTriggeredByEvent;
        ScopeImpl scope = bpmnParse.getCurrentScope();
        Object triggeredByEvent = scope.getProperty("triggeredByEvent");
        boolean bl = isTriggeredByEvent = triggeredByEvent != null && (Boolean)triggeredByEvent != false;
        if (isTriggeredByEvent) {
            EventSubProcessStartEventActivityBehavior activityBehavior = bpmnParse.getActivityBehaviorFactory().createEventSubProcessStartEventActivityBehavior(startEvent, startEventActivity.getId());
            startEventActivity.setActivityBehavior(activityBehavior);
            if (!startEvent.getEventDefinitions().isEmpty()) {
                EventDefinition eventDefinition = (EventDefinition)startEvent.getEventDefinitions().get(0);
                if (eventDefinition instanceof ErrorEventDefinition || eventDefinition instanceof MessageEventDefinition || eventDefinition instanceof SignalEventDefinition) {
                    bpmnParse.getBpmnParserHandlers().parseElement(bpmnParse, (BaseElement)eventDefinition);
                } else {
                    LOGGER.warn("start event of event subprocess must be of type 'error', 'message' or 'signal' for start event {}", (Object)startEvent.getId());
                }
            }
        } else {
            if (!startEvent.getEventDefinitions().isEmpty()) {
                LOGGER.warn("event definitions only allowed on start event if subprocess is an event subprocess {}", (Object)bpmnParse.getCurrentSubProcess().getId());
            }
            if (scope.getProperty(PROPERTYNAME_INITIAL) == null) {
                scope.setProperty(PROPERTYNAME_INITIAL, startEventActivity);
                startEventActivity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createNoneStartEventActivityBehavior(startEvent));
            } else {
                LOGGER.warn("multiple start events not supported for subprocess {}", (Object)bpmnParse.getCurrentSubProcess().getId());
            }
        }
    }
}

