/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import org.activiti.engine.impl.bpmn.behavior.WebServiceActivityBehavior;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractExternalInvocationBpmnParseHandler;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.ServiceTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceTaskParseHandler
extends AbstractExternalInvocationBpmnParseHandler<ServiceTask> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceTaskParseHandler.class);

    @Override
    public Class<? extends BaseElement> getHandledType() {
        return ServiceTask.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, ServiceTask serviceTask) {
        ActivityImpl activity = this.createActivityOnCurrentScope(bpmnParse, (FlowElement)serviceTask, "serviceTask");
        activity.setAsync(serviceTask.isAsynchronous());
        activity.setFailedJobRetryTimeCycleValue(serviceTask.getFailedJobRetryTimeCycleValue());
        activity.setExclusive(!serviceTask.isNotExclusive());
        if (StringUtils.isNotEmpty((CharSequence)serviceTask.getType())) {
            if ("mail".equalsIgnoreCase(serviceTask.getType())) {
                activity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createMailActivityBehavior(serviceTask));
            } else if ("camel".equalsIgnoreCase(serviceTask.getType())) {
                activity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createCamelActivityBehavior(serviceTask, bpmnParse.getBpmnModel()));
            } else if ("shell".equalsIgnoreCase(serviceTask.getType())) {
                activity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createShellActivityBehavior(serviceTask));
            } else {
                LOGGER.warn("Invalid service task type: '{}'  for service task {}", (Object)serviceTask.getType(), (Object)serviceTask.getId());
            }
        } else if ("class".equalsIgnoreCase(serviceTask.getImplementationType())) {
            activity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createClassDelegateServiceTask(serviceTask));
        } else if ("delegateExpression".equalsIgnoreCase(serviceTask.getImplementationType())) {
            activity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createServiceTaskDelegateExpressionActivityBehavior(serviceTask));
        } else if ("expression".equalsIgnoreCase(serviceTask.getImplementationType())) {
            activity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createServiceTaskExpressionActivityBehavior(serviceTask));
        } else if ("##WebService".equalsIgnoreCase(serviceTask.getImplementationType()) && StringUtils.isNotEmpty((CharSequence)serviceTask.getOperationRef())) {
            WebServiceActivityBehavior webServiceActivityBehavior = bpmnParse.getActivityBehaviorFactory().createWebServiceActivityBehavior(serviceTask, bpmnParse.getBpmnModel());
            activity.setActivityBehavior(webServiceActivityBehavior);
        } else {
            LOGGER.warn("One of the attributes 'class', 'delegateExpression', 'type', 'operation', or 'expression' is mandatory on serviceTask {}", (Object)serviceTask.getId());
        }
    }
}

