/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import org.activiti.engine.impl.bpmn.behavior.WebServiceActivityBehavior;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractExternalInvocationBpmnParseHandler;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.SendTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendTaskParseHandler
extends AbstractExternalInvocationBpmnParseHandler<SendTask> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SendTaskParseHandler.class);

    @Override
    public Class<? extends BaseElement> getHandledType() {
        return SendTask.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, SendTask sendTask) {
        ActivityImpl activity = this.createActivityOnCurrentScope(bpmnParse, (FlowElement)sendTask, "sendTask");
        activity.setAsync(sendTask.isAsynchronous());
        activity.setExclusive(!sendTask.isNotExclusive());
        if (StringUtils.isNotEmpty((CharSequence)sendTask.getType())) {
            if ("mail".equalsIgnoreCase(sendTask.getType())) {
                activity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createMailActivityBehavior(sendTask));
            } else if ("camel".equalsIgnoreCase(sendTask.getType())) {
                activity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createCamelActivityBehavior(sendTask, bpmnParse.getBpmnModel()));
            }
        } else if ("##WebService".equalsIgnoreCase(sendTask.getImplementationType()) && StringUtils.isNotEmpty((CharSequence)sendTask.getOperationRef())) {
            WebServiceActivityBehavior webServiceActivityBehavior = bpmnParse.getActivityBehaviorFactory().createWebServiceActivityBehavior(sendTask, bpmnParse.getBpmnModel());
            activity.setActivityBehavior(webServiceActivityBehavior);
        } else {
            LOGGER.warn("One of the attributes 'type' or 'operation' is mandatory on sendTask {}", (Object)sendTask.getId());
        }
    }
}

