/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.EventSubscriptionDeclaration;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.ScopeImpl;
import org.activiti.engine.impl.pvm.process.TransitionImpl;
import org.activiti.engine.parse.BpmnParseHandler;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.Artifact;
import org.flowable.bpmn.model.Association;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.EventGateway;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowableListener;
import org.flowable.bpmn.model.Gateway;
import org.flowable.bpmn.model.IntermediateCatchEvent;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.ValuedDataObject;
import org.flowable.engine.delegate.ExecutionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBpmnParseHandler<T extends BaseElement>
implements BpmnParseHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractBpmnParseHandler.class);
    public static final String PROPERTYNAME_IS_FOR_COMPENSATION = "isForCompensation";
    public static final String PROPERTYNAME_EVENT_SUBSCRIPTION_DECLARATION = "eventDefinitions";
    public static final String PROPERTYNAME_ERROR_EVENT_DEFINITIONS = "errorEventDefinitions";
    public static final String PROPERTYNAME_TIMER_DECLARATION = "timerDeclarations";

    public Set<Class<? extends BaseElement>> getHandledTypes() {
        HashSet<Class<? extends BaseElement>> types = new HashSet<Class<? extends BaseElement>>();
        types.add(this.getHandledType());
        return types;
    }

    protected abstract Class<? extends BaseElement> getHandledType();

    @Override
    public void parse(BpmnParse bpmnParse, BaseElement element) {
        BaseElement baseElement = element;
        this.executeParse(bpmnParse, baseElement);
    }

    protected abstract void executeParse(BpmnParse var1, T var2);

    protected ActivityImpl findActivity(BpmnParse bpmnParse, String id) {
        return bpmnParse.getCurrentScope().findActivity(id);
    }

    public ActivityImpl createActivityOnCurrentScope(BpmnParse bpmnParse, FlowElement flowElement, String xmlLocalName) {
        return this.createActivityOnScope(bpmnParse, flowElement, xmlLocalName, bpmnParse.getCurrentScope());
    }

    public ActivityImpl createActivityOnScope(BpmnParse bpmnParse, FlowElement flowElement, String xmlLocalName, ScopeImpl scopeElement) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Parsing activity {}", (Object)flowElement.getId());
        }
        ActivityImpl activity = scopeElement.createActivity(flowElement.getId());
        bpmnParse.setCurrentActivity(activity);
        activity.setProperty("name", flowElement.getName());
        activity.setProperty("documentation", flowElement.getDocumentation());
        if (flowElement instanceof Activity) {
            Activity modelActivity = (Activity)flowElement;
            activity.setProperty("default", modelActivity.getDefaultFlow());
            if (modelActivity.isForCompensation()) {
                activity.setProperty(PROPERTYNAME_IS_FOR_COMPENSATION, true);
            }
        } else if (flowElement instanceof Gateway) {
            activity.setProperty("default", ((Gateway)flowElement).getDefaultFlow());
        }
        activity.setProperty("type", xmlLocalName);
        return activity;
    }

    protected void createExecutionListenersOnScope(BpmnParse bpmnParse, List<FlowableListener> activitiListenerList, ScopeImpl scope) {
        for (FlowableListener activitiListener : activitiListenerList) {
            scope.addExecutionListener(activitiListener.getEvent(), this.createExecutionListener(bpmnParse, activitiListener));
        }
    }

    protected void createExecutionListenersOnTransition(BpmnParse bpmnParse, List<FlowableListener> activitiListenerList, TransitionImpl transition) {
        for (FlowableListener activitiListener : activitiListenerList) {
            transition.addExecutionListener(this.createExecutionListener(bpmnParse, activitiListener));
        }
    }

    protected ExecutionListener createExecutionListener(BpmnParse bpmnParse, FlowableListener activitiListener) {
        ExecutionListener executionListener = null;
        if ("class".equalsIgnoreCase(activitiListener.getImplementationType())) {
            executionListener = bpmnParse.getListenerFactory().createClassDelegateExecutionListener(activitiListener);
        } else if ("expression".equalsIgnoreCase(activitiListener.getImplementationType())) {
            executionListener = bpmnParse.getListenerFactory().createExpressionExecutionListener(activitiListener);
        } else if ("delegateExpression".equalsIgnoreCase(activitiListener.getImplementationType())) {
            executionListener = bpmnParse.getListenerFactory().createDelegateExpressionExecutionListener(activitiListener);
        }
        return executionListener;
    }

    protected void addEventSubscriptionDeclaration(BpmnParse bpmnParse, EventSubscriptionDeclaration subscription, EventDefinition parsedEventDefinition, ScopeImpl scope) {
        ArrayList<EventSubscriptionDeclaration> eventDefinitions = (ArrayList<EventSubscriptionDeclaration>)scope.getProperty(PROPERTYNAME_EVENT_SUBSCRIPTION_DECLARATION);
        if (eventDefinitions == null) {
            eventDefinitions = new ArrayList<EventSubscriptionDeclaration>();
            scope.setProperty(PROPERTYNAME_EVENT_SUBSCRIPTION_DECLARATION, eventDefinitions);
        } else if ("message".equals(subscription.getEventType())) {
            for (EventSubscriptionDeclaration eventDefinition : eventDefinitions) {
                if (!"message".equals(eventDefinition.getEventType()) || !eventDefinition.getEventName().equals(subscription.getEventName()) || eventDefinition.isStartEvent() != subscription.isStartEvent()) continue;
                LOGGER.warn("Cannot have more than one message event subscription with name '{}' for scope '{}'", (Object)subscription.getEventName(), (Object)scope.getId());
            }
        }
        eventDefinitions.add(subscription);
    }

    protected String getPrecedingEventBasedGateway(BpmnParse bpmnParse, IntermediateCatchEvent event) {
        String eventBasedGatewayId = null;
        for (SequenceFlow sequenceFlow : event.getIncomingFlows()) {
            FlowElement sourceElement = bpmnParse.getBpmnModel().getFlowElement(sequenceFlow.getSourceRef());
            if (!(sourceElement instanceof EventGateway)) continue;
            eventBasedGatewayId = sourceElement.getId();
            break;
        }
        return eventBasedGatewayId;
    }

    protected void processArtifacts(BpmnParse bpmnParse, Collection<Artifact> artifacts, ScopeImpl scope) {
        for (Artifact artifact : artifacts) {
            if (!(artifact instanceof Association)) continue;
            this.createAssociation(bpmnParse, (Association)artifact, scope);
        }
    }

    protected void createAssociation(BpmnParse bpmnParse, Association association, ScopeImpl parentScope) {
        BpmnModel bpmnModel = bpmnParse.getBpmnModel();
        if (bpmnModel.getArtifact(association.getSourceRef()) != null || bpmnModel.getArtifact(association.getTargetRef()) != null) {
            return;
        }
        ActivityImpl sourceActivity = parentScope.findActivity(association.getSourceRef());
        ActivityImpl targetActivity = parentScope.findActivity(association.getTargetRef());
        if (sourceActivity != null && targetActivity != null && sourceActivity.getProperty("type").equals("compensationBoundaryCatch")) {
            Object isForCompensation = targetActivity.getProperty(PROPERTYNAME_IS_FOR_COMPENSATION);
            if (isForCompensation == null || !((Boolean)isForCompensation).booleanValue()) {
                LOGGER.warn("compensation boundary catch must be connected to element with isForCompensation=true");
            } else {
                ActivityImpl compensatedActivity = sourceActivity.getParentActivity();
                compensatedActivity.setProperty("compensationHandler", targetActivity.getId());
            }
        }
    }

    protected Map<String, Object> processDataObjects(BpmnParse bpmnParse, Collection<ValuedDataObject> dataObjects, ScopeImpl scope) {
        HashMap<String, Object> variablesMap = new HashMap<String, Object>();
        if (dataObjects != null) {
            for (ValuedDataObject dataObject : dataObjects) {
                variablesMap.put(dataObject.getName(), dataObject.getValue());
            }
        }
        return variablesMap;
    }
}

