/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.listener;

import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.impl.bpmn.helper.ClassDelegate;
import org.activiti.engine.impl.bpmn.parser.FieldDeclaration;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.delegate.TaskListenerInvocation;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.engine.delegate.TaskListener;
import org.flowable.task.service.delegate.DelegateTask;

public class DelegateExpressionTaskListener
implements TaskListener {
    protected Expression expression;
    private final List<FieldDeclaration> fieldDeclarations;

    public DelegateExpressionTaskListener(Expression expression, List<FieldDeclaration> fieldDeclarations) {
        this.expression = expression;
        this.fieldDeclarations = fieldDeclarations;
    }

    public void notify(DelegateTask delegateTask) {
        Object delegate = this.expression.getValue((VariableContainer)delegateTask);
        ClassDelegate.applyFieldDeclaration(this.fieldDeclarations, delegate);
        if (delegate instanceof TaskListener) {
            try {
                Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new TaskListenerInvocation((TaskListener)delegate, delegateTask));
            }
            catch (Exception e) {
                throw new ActivitiException("Exception while invoking TaskListener: " + e.getMessage(), e);
            }
        } else {
            throw new ActivitiIllegalArgumentException("Delegate expression " + String.valueOf(this.expression) + " did not resolve to an implementation of " + String.valueOf(TaskListener.class));
        }
    }

    public String getExpressionText() {
        return this.expression.getExpressionText();
    }
}

