/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.delegate.BpmnError;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.activiti.engine.impl.bpmn.helper.DelegateExpressionUtil;
import org.activiti.engine.impl.bpmn.helper.ErrorPropagation;
import org.activiti.engine.impl.bpmn.helper.SkipExpressionUtil;
import org.activiti.engine.impl.bpmn.parser.FieldDeclaration;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.delegate.ActivityBehaviorInvocation;
import org.activiti.engine.impl.delegate.JavaDelegateInvocation;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.delegate.SignallableActivityBehavior;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.MapExceptionEntry;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.JavaDelegate;
import org.flowable.engine.impl.delegate.ActivityBehavior;
import org.flowable.variable.api.delegate.VariableScope;

public class ServiceTaskDelegateExpressionActivityBehavior
extends TaskActivityBehavior {
    protected String serviceTaskId;
    protected Expression expression;
    protected Expression skipExpression;
    protected List<FieldDeclaration> fieldDeclarations;
    protected List<MapExceptionEntry> mapExceptions;

    public ServiceTaskDelegateExpressionActivityBehavior(String serviceTaskId, Expression expression, Expression skipExpression, List<FieldDeclaration> fieldDeclarations, List<MapExceptionEntry> mapExceptions) {
        this.serviceTaskId = serviceTaskId;
        this.expression = expression;
        this.skipExpression = skipExpression;
        this.fieldDeclarations = fieldDeclarations;
        this.mapExceptions = mapExceptions;
    }

    @Override
    public void signal(ActivityExecution execution, String signalName, Object signalData) throws Exception {
        Object delegate = DelegateExpressionUtil.resolveDelegateExpression(this.expression, (VariableScope)execution, this.fieldDeclarations);
        if (delegate instanceof SignallableActivityBehavior) {
            ((SignallableActivityBehavior)delegate).signal(execution, signalName, signalData);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(DelegateExecution execution) {
        ActivityExecution activityExecution = (ActivityExecution)execution;
        try {
            boolean isSkipExpressionEnabled = SkipExpressionUtil.isSkipExpressionEnabled(activityExecution, this.skipExpression);
            if (!isSkipExpressionEnabled || isSkipExpressionEnabled && !SkipExpressionUtil.shouldSkipFlowElement(activityExecution, this.skipExpression)) {
                Object object;
                String overrideExpression;
                ObjectNode objectNode;
                if (Context.getProcessEngineConfiguration().isEnableProcessDefinitionInfoCache() && (objectNode = Context.getBpmnOverrideElementProperties(this.serviceTaskId, execution.getProcessDefinitionId())) != null && objectNode.has("serviceTaskDelegateExpression") && StringUtils.isNotEmpty((CharSequence)(overrideExpression = objectNode.get("serviceTaskDelegateExpression").asText())) && !overrideExpression.equals(this.expression.getExpressionText())) {
                    this.expression = Context.getProcessEngineConfiguration().getExpressionManager().createExpression(overrideExpression);
                }
                if ((object = DelegateExpressionUtil.resolveDelegateExpression(this.expression, (VariableScope)execution, this.fieldDeclarations)) instanceof ActivityBehavior) {
                    if (object instanceof AbstractBpmnActivityBehavior) {
                        ((AbstractBpmnActivityBehavior)object).setMultiInstanceActivityBehavior(this.getMultiInstanceActivityBehavior());
                    }
                    Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new ActivityBehaviorInvocation((ActivityBehavior)object, activityExecution));
                    return;
                } else {
                    if (!(object instanceof JavaDelegate)) throw new ActivitiIllegalArgumentException("Delegate expression " + String.valueOf(this.expression) + " did neither resolve to an implementation of " + String.valueOf(ActivityBehavior.class) + " nor " + String.valueOf(JavaDelegate.class));
                    Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new JavaDelegateInvocation((JavaDelegate)object, execution));
                    this.leave(activityExecution);
                }
                return;
            } else {
                this.leave(activityExecution);
            }
            return;
        }
        catch (Exception exc) {
            void var4_8;
            Exception exception = exc;
            BpmnError error = null;
            while (var4_8 != null) {
                if (var4_8 instanceof BpmnError) {
                    error = (BpmnError)var4_8;
                    break;
                }
                if (var4_8 instanceof RuntimeException && ErrorPropagation.mapException((RuntimeException)var4_8, activityExecution, this.mapExceptions)) {
                    return;
                }
                Throwable throwable = var4_8.getCause();
            }
            if (error == null) throw new ActivitiException(exc.getMessage(), exc);
            ErrorPropagation.propagateError(error, activityExecution);
            return;
        }
    }
}

