/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.BpmnError;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.engine.impl.bpmn.helper.ErrorPropagation;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.persistence.deploy.DeploymentManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.PvmProcessInstance;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.delegate.SubProcessActivityBehavior;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.MapExceptionEntry;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.data.AbstractDataAssociation;
import org.flowable.engine.repository.ProcessDefinition;

public class CallActivityBehavior
extends AbstractBpmnActivityBehavior
implements SubProcessActivityBehavior {
    protected String processDefinitonKey;
    private List<AbstractDataAssociation> dataInputAssociations = new ArrayList<AbstractDataAssociation>();
    private List<AbstractDataAssociation> dataOutputAssociations = new ArrayList<AbstractDataAssociation>();
    private Expression processDefinitionExpression;
    protected List<MapExceptionEntry> mapExceptions;
    protected boolean inheritVariables;
    protected boolean sameDeployment;
    protected String businessKey;
    protected boolean inheritBusinessKey;

    public CallActivityBehavior(String processDefinitionKey, List<MapExceptionEntry> mapExceptions) {
        this.processDefinitonKey = processDefinitionKey;
        this.mapExceptions = mapExceptions;
    }

    public CallActivityBehavior(Expression processDefinitionExpression, List<MapExceptionEntry> mapExceptions) {
        this.processDefinitionExpression = processDefinitionExpression;
        this.mapExceptions = mapExceptions;
    }

    public void addDataInputAssociation(AbstractDataAssociation dataInputAssociation) {
        this.dataInputAssociations.add(dataInputAssociation);
    }

    public void addDataOutputAssociation(AbstractDataAssociation dataOutputAssociation) {
        this.dataOutputAssociations.add(dataOutputAssociation);
    }

    @Override
    public void execute(DelegateExecution execution) {
        String processDefinitonKey = this.processDefinitonKey;
        if (this.processDefinitionExpression != null) {
            processDefinitonKey = (String)this.processDefinitionExpression.getValue((VariableContainer)execution);
        }
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        DeploymentManager deploymentManager = processEngineConfiguration.getDeploymentManager();
        ProcessDefinition processDefinition = null;
        if (this.sameDeployment) {
            String deploymentId = deploymentManager.findDeployedProcessDefinitionById(execution.getProcessDefinitionId()).getDeploymentId();
            processDefinition = Context.getCommandContext().getProcessDefinitionEntityManager().findProcessDefinitionByDeploymentAndKey(deploymentId, processDefinitonKey);
            processDefinition = deploymentManager.findDeployedProcessDefinitionById(processDefinition.getId());
        }
        if (processDefinition == null) {
            processDefinition = execution.getTenantId() == null || "".equals(execution.getTenantId()) ? deploymentManager.findDeployedLatestProcessDefinitionByKey(processDefinitonKey) : deploymentManager.findDeployedLatestProcessDefinitionByKeyAndTenantId(processDefinitonKey, execution.getTenantId());
        }
        if (deploymentManager.isProcessDefinitionSuspended(processDefinition.getId())) {
            throw new ActivitiException("Cannot start process instance. Process definition " + processDefinition.getName() + " (id = " + processDefinition.getId() + ") is suspended");
        }
        ActivityExecution activityExecution = (ActivityExecution)execution;
        PvmProcessInstance subProcessInstance = activityExecution.createSubProcessInstance((ProcessDefinitionEntity)processDefinition);
        if (this.inheritVariables) {
            Map variables = execution.getVariables();
            for (Map.Entry entry : variables.entrySet()) {
                subProcessInstance.setVariable((String)entry.getKey(), entry.getValue());
            }
        }
        String subProcessInstanceBusinessKey = null;
        if (StringUtils.isNotEmpty((CharSequence)this.businessKey)) {
            ExpressionManager expressionManager = processEngineConfiguration.getExpressionManager();
            Expression expression = expressionManager.createExpression(this.businessKey);
            subProcessInstanceBusinessKey = expression.getValue((VariableContainer)execution).toString();
        } else if (this.inheritBusinessKey) {
            ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
            ExecutionEntity parentProcessInstance = executionEntityManager.findExecutionById(execution.getProcessInstanceId());
            subProcessInstanceBusinessKey = parentProcessInstance.getBusinessKey();
        }
        if (StringUtils.isNotEmpty(subProcessInstanceBusinessKey) && subProcessInstance instanceof ExecutionEntity) {
            ((ExecutionEntity)subProcessInstance).setBusinessKey(subProcessInstanceBusinessKey);
        }
        for (AbstractDataAssociation dataInputAssociation : this.dataInputAssociations) {
            Object value = null;
            value = dataInputAssociation.getSourceExpression() != null ? dataInputAssociation.getSourceExpression().getValue((VariableContainer)execution) : execution.getVariable(dataInputAssociation.getSource());
            subProcessInstance.setVariable(dataInputAssociation.getTarget(), value);
        }
        try {
            subProcessInstance.start();
        }
        catch (RuntimeException e) {
            BpmnError error = null;
            for (Throwable cause = e; cause != null; cause = cause.getCause()) {
                if (cause instanceof BpmnError) {
                    error = (BpmnError)cause;
                    break;
                }
                if (!(cause instanceof RuntimeException) || !ErrorPropagation.mapException(cause, activityExecution, this.mapExceptions)) continue;
                return;
            }
            if (error != null) {
                ErrorPropagation.propagateError(error, activityExecution);
            }
            throw e;
        }
    }

    @Override
    public void completing(DelegateExecution execution, DelegateExecution subProcessInstance) throws Exception {
        for (AbstractDataAssociation dataOutputAssociation : this.dataOutputAssociations) {
            Object value = null;
            value = dataOutputAssociation.getSourceExpression() != null ? dataOutputAssociation.getSourceExpression().getValue((VariableContainer)subProcessInstance) : subProcessInstance.getVariable(dataOutputAssociation.getSource());
            execution.setVariable(dataOutputAssociation.getTarget(), value);
        }
    }

    @Override
    public void completed(ActivityExecution execution) throws Exception {
        this.leave(execution);
    }

    public void setProcessDefinitonKey(String processDefinitonKey) {
        this.processDefinitonKey = processDefinitonKey;
    }

    public String getProcessDefinitonKey() {
        return this.processDefinitonKey;
    }

    public void setInheritVariables(boolean inheritVariables) {
        this.inheritVariables = inheritVariables;
    }

    public void setSameDeployment(boolean sameDeployment) {
        this.sameDeployment = sameDeployment;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    public boolean isInheritBusinessKey() {
        return this.inheritBusinessKey;
    }

    public void setInheritBusinessKey(boolean inheritBusinessKey) {
        this.inheritBusinessKey = inheritBusinessKey;
    }
}

