/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl;

import java.util.List;
import java.util.Set;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.history.HistoricVariableInstance;
import org.activiti.engine.history.HistoricVariableInstanceQuery;
import org.activiti.engine.impl.AbstractQuery;
import org.activiti.engine.impl.HistoricVariableInstanceQueryProperty;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.QueryOperator;
import org.activiti.engine.impl.QueryVariableValue;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.flowable.variable.api.types.VariableTypes;
import org.flowable.variable.service.impl.types.CacheableVariable;

public class HistoricVariableInstanceQueryImpl
extends AbstractQuery<HistoricVariableInstanceQuery, HistoricVariableInstance>
implements HistoricVariableInstanceQuery {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String taskId;
    protected Set<String> taskIds;
    protected String executionId;
    protected Set<String> executionIds;
    protected String processInstanceId;
    protected String activityInstanceId;
    protected String variableName;
    protected String variableNameLike;
    protected boolean excludeTaskRelated;
    protected boolean excludeVariableInitialization;
    protected QueryVariableValue queryVariableValue;

    public HistoricVariableInstanceQueryImpl() {
    }

    public HistoricVariableInstanceQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public HistoricVariableInstanceQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public HistoricVariableInstanceQuery id(String id) {
        this.id = id;
        return this;
    }

    @Override
    public HistoricVariableInstanceQueryImpl processInstanceId(String processInstanceId) {
        if (processInstanceId == null) {
            throw new ActivitiIllegalArgumentException("processInstanceId is null");
        }
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public HistoricVariableInstanceQueryImpl executionId(String executionId) {
        if (executionId == null) {
            throw new ActivitiIllegalArgumentException("Execution id is null");
        }
        this.executionId = executionId;
        return this;
    }

    @Override
    public HistoricVariableInstanceQueryImpl executionIds(Set<String> executionIds) {
        if (executionIds == null) {
            throw new ActivitiIllegalArgumentException("executionIds is null");
        }
        if (executionIds.isEmpty()) {
            throw new ActivitiIllegalArgumentException("Set of executionIds is empty");
        }
        this.executionIds = executionIds;
        return this;
    }

    public HistoricVariableInstanceQuery activityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
        return this;
    }

    @Override
    public HistoricVariableInstanceQuery taskId(String taskId) {
        if (taskId == null) {
            throw new ActivitiIllegalArgumentException("taskId is null");
        }
        if (this.excludeTaskRelated) {
            throw new ActivitiIllegalArgumentException("Cannot use taskId together with excludeTaskVariables");
        }
        this.taskId = taskId;
        return this;
    }

    @Override
    public HistoricVariableInstanceQueryImpl taskIds(Set<String> taskIds) {
        if (taskIds == null) {
            throw new ActivitiIllegalArgumentException("taskIds is null");
        }
        if (taskIds.isEmpty()) {
            throw new ActivitiIllegalArgumentException("Set of taskIds is empty");
        }
        if (this.excludeTaskRelated) {
            throw new ActivitiIllegalArgumentException("Cannot use taskIds together with excludeTaskVariables");
        }
        this.taskIds = taskIds;
        return this;
    }

    @Override
    public HistoricVariableInstanceQuery excludeTaskVariables() {
        if (this.taskId != null) {
            throw new ActivitiIllegalArgumentException("Cannot use taskId together with excludeTaskVariables");
        }
        if (this.taskIds != null) {
            throw new ActivitiIllegalArgumentException("Cannot use taskIds together with excludeTaskVariables");
        }
        this.excludeTaskRelated = true;
        return this;
    }

    @Override
    public HistoricVariableInstanceQuery excludeVariableInitialization() {
        this.excludeVariableInitialization = true;
        return this;
    }

    @Override
    public HistoricVariableInstanceQuery variableName(String variableName) {
        if (variableName == null) {
            throw new ActivitiIllegalArgumentException("variableName is null");
        }
        this.variableName = variableName;
        return this;
    }

    @Override
    public HistoricVariableInstanceQuery variableValueEquals(String variableName, Object variableValue) {
        if (variableName == null) {
            throw new ActivitiIllegalArgumentException("variableName is null");
        }
        if (variableValue == null) {
            throw new ActivitiIllegalArgumentException("variableValue is null");
        }
        this.variableName = variableName;
        this.queryVariableValue = new QueryVariableValue(variableName, variableValue, QueryOperator.EQUALS, true);
        return this;
    }

    @Override
    public HistoricVariableInstanceQuery variableValueNotEquals(String variableName, Object variableValue) {
        if (variableName == null) {
            throw new ActivitiIllegalArgumentException("variableName is null");
        }
        if (variableValue == null) {
            throw new ActivitiIllegalArgumentException("variableValue is null");
        }
        this.variableName = variableName;
        this.queryVariableValue = new QueryVariableValue(variableName, variableValue, QueryOperator.NOT_EQUALS, true);
        return this;
    }

    @Override
    public HistoricVariableInstanceQuery variableValueLike(String variableName, String variableValue) {
        if (variableName == null) {
            throw new ActivitiIllegalArgumentException("variableName is null");
        }
        if (variableValue == null) {
            throw new ActivitiIllegalArgumentException("variableValue is null");
        }
        this.variableName = variableName;
        this.queryVariableValue = new QueryVariableValue(variableName, variableValue, QueryOperator.LIKE, true);
        return this;
    }

    @Override
    public HistoricVariableInstanceQuery variableValueLikeIgnoreCase(String variableName, String variableValue) {
        if (variableName == null) {
            throw new ActivitiIllegalArgumentException("variableName is null");
        }
        if (variableValue == null) {
            throw new ActivitiIllegalArgumentException("variableValue is null");
        }
        this.variableName = variableName;
        this.queryVariableValue = new QueryVariableValue(variableName, variableValue.toLowerCase(), QueryOperator.LIKE_IGNORE_CASE, true);
        return this;
    }

    @Override
    public HistoricVariableInstanceQuery variableNameLike(String variableNameLike) {
        if (variableNameLike == null) {
            throw new ActivitiIllegalArgumentException("variableNameLike is null");
        }
        this.variableNameLike = variableNameLike;
        return this;
    }

    protected void ensureVariablesInitialized() {
        if (this.queryVariableValue != null) {
            VariableTypes variableTypes = Context.getProcessEngineConfiguration().getVariableTypes();
            this.queryVariableValue.initialize(variableTypes);
        }
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        this.ensureVariablesInitialized();
        return commandContext.getHistoricVariableInstanceEntityManager().findHistoricVariableInstanceCountByQueryCriteria(this);
    }

    @Override
    public List<HistoricVariableInstance> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        this.ensureVariablesInitialized();
        List<HistoricVariableInstance> historicVariableInstances = commandContext.getHistoricVariableInstanceEntityManager().findHistoricVariableInstancesByQueryCriteria(this, page);
        if (!this.excludeVariableInitialization) {
            for (HistoricVariableInstance historicVariableInstance : historicVariableInstances) {
                HistoricVariableInstanceEntity variableEntity;
                if (!(historicVariableInstance instanceof HistoricVariableInstanceEntity) || (variableEntity = (HistoricVariableInstanceEntity)historicVariableInstance).getVariableType() == null) continue;
                variableEntity.getValue();
                if (!"jpa-entity".equals(variableEntity.getVariableType().getTypeName()) && !"jpa-entity-list".equals(variableEntity.getVariableType().getTypeName())) continue;
                ((CacheableVariable)variableEntity.getVariableType()).setForceCacheable(true);
            }
        }
        return historicVariableInstances;
    }

    @Override
    public HistoricVariableInstanceQuery orderByProcessInstanceId() {
        this.orderBy(HistoricVariableInstanceQueryProperty.PROCESS_INSTANCE_ID);
        return this;
    }

    @Override
    public HistoricVariableInstanceQuery orderByVariableName() {
        this.orderBy(HistoricVariableInstanceQueryProperty.VARIABLE_NAME);
        return this;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    public boolean getExcludeTaskRelated() {
        return this.excludeTaskRelated;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String getVariableNameLike() {
        return this.variableNameLike;
    }

    public String getId() {
        return this.id;
    }

    public Set<String> getTaskIds() {
        return this.taskIds;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public Set<String> getExecutionIds() {
        return this.executionIds;
    }

    public boolean isExcludeTaskRelated() {
        return this.excludeTaskRelated;
    }

    public boolean isExcludeVariableInitialization() {
        return this.excludeVariableInitialization;
    }

    public QueryVariableValue getQueryVariableValue() {
        return this.queryVariableValue;
    }
}

