/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.delegate.event.impl;

import java.util.Map;
import org.activiti.engine.delegate.event.impl.ActivitiActivityCancelledEventImpl;
import org.activiti.engine.delegate.event.impl.ActivitiActivityEventImpl;
import org.activiti.engine.delegate.event.impl.ActivitiEntityEventImpl;
import org.activiti.engine.delegate.event.impl.ActivitiEntityExceptionEventImpl;
import org.activiti.engine.delegate.event.impl.ActivitiEntityWithVariablesEventImpl;
import org.activiti.engine.delegate.event.impl.ActivitiErrorEventImpl;
import org.activiti.engine.delegate.event.impl.ActivitiEventImpl;
import org.activiti.engine.delegate.event.impl.ActivitiMembershipEventImpl;
import org.activiti.engine.delegate.event.impl.ActivitiMessageEventImpl;
import org.activiti.engine.delegate.event.impl.ActivitiProcessCancelledEventImpl;
import org.activiti.engine.delegate.event.impl.ActivitiProcessStartedEventImpl;
import org.activiti.engine.delegate.event.impl.ActivitiSequenceFlowTakenEventImpl;
import org.activiti.engine.delegate.event.impl.ActivitiSignalEventImpl;
import org.activiti.engine.delegate.event.impl.ActivitiVariableEventImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.context.ExecutionContext;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.task.Task;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEntityEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.event.FlowableActivityCancelledEvent;
import org.flowable.engine.delegate.event.FlowableActivityEvent;
import org.flowable.engine.delegate.event.FlowableCancelledEvent;
import org.flowable.engine.delegate.event.FlowableEntityWithVariablesEvent;
import org.flowable.engine.delegate.event.FlowableErrorEvent;
import org.flowable.engine.delegate.event.FlowableMessageEvent;
import org.flowable.engine.delegate.event.FlowableProcessStartedEvent;
import org.flowable.engine.delegate.event.FlowableSequenceFlowTakenEvent;
import org.flowable.engine.delegate.event.FlowableSignalEvent;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.idm.api.event.FlowableIdmEventType;
import org.flowable.idm.api.event.FlowableIdmMembershipEvent;
import org.flowable.job.api.Job;
import org.flowable.variable.api.event.FlowableVariableEvent;
import org.flowable.variable.api.types.VariableType;

public class ActivitiEventBuilder {
    public static FlowableEvent createGlobalEvent(FlowableEngineEventType type) {
        ActivitiEventImpl newEvent = new ActivitiEventImpl(type);
        return newEvent;
    }

    public static FlowableEvent createEvent(FlowableEngineEventType type, String executionId, String processInstanceId, String processDefinitionId) {
        ActivitiEventImpl newEvent = new ActivitiEventImpl(type);
        newEvent.setExecutionId(executionId);
        newEvent.setProcessDefinitionId(processDefinitionId);
        newEvent.setProcessInstanceId(processInstanceId);
        return newEvent;
    }

    public static FlowableEntityEvent createEntityEvent(FlowableEngineEventType type, Object entity) {
        ActivitiEntityEventImpl newEvent = new ActivitiEntityEventImpl(entity, type);
        ActivitiEventBuilder.populateEventWithCurrentContext(newEvent);
        return newEvent;
    }

    public static FlowableProcessStartedEvent createProcessStartedEvent(Object entity, Map variables, boolean localScope) {
        ActivitiProcessStartedEventImpl newEvent = new ActivitiProcessStartedEventImpl(entity, variables, localScope);
        ActivitiEventBuilder.populateEventWithCurrentContext(newEvent);
        return newEvent;
    }

    public static FlowableEntityWithVariablesEvent createEntityWithVariablesEvent(FlowableEngineEventType type, Object entity, Map variables, boolean localScope) {
        ActivitiEntityWithVariablesEventImpl newEvent = new ActivitiEntityWithVariablesEventImpl(entity, variables, localScope, type);
        ActivitiEventBuilder.populateEventWithCurrentContext(newEvent);
        return newEvent;
    }

    public static FlowableSequenceFlowTakenEvent createSequenceFlowTakenEvent(FlowableEngineEventType type, String sequenceFlowId, String sourceActivityId, String sourceActivityName, String sourceActivityType, String sourceActivityBehaviorClass, String targetActivityId, String targetActivityName, String targetActivityType, String targetActivityBehaviorClass) {
        ActivitiSequenceFlowTakenEventImpl newEvent = new ActivitiSequenceFlowTakenEventImpl(type);
        ActivitiEventBuilder.populateEventWithCurrentContext(newEvent);
        newEvent.setId(sequenceFlowId);
        newEvent.setSourceActivityId(sourceActivityId);
        newEvent.setSourceActivityName(sourceActivityName);
        newEvent.setSourceActivityType(sourceActivityType);
        newEvent.setSourceActivityBehaviorClass(sourceActivityBehaviorClass);
        newEvent.setTargetActivityId(targetActivityId);
        newEvent.setTargetActivityName(targetActivityName);
        newEvent.setTargetActivityType(targetActivityType);
        newEvent.setTargetActivityBehaviorClass(targetActivityBehaviorClass);
        return newEvent;
    }

    public static FlowableEntityEvent createEntityEvent(FlowableEngineEventType type, Object entity, String executionId, String processInstanceId, String processDefinitionId) {
        ActivitiEntityEventImpl newEvent = new ActivitiEntityEventImpl(entity, type);
        newEvent.setExecutionId(executionId);
        newEvent.setProcessInstanceId(processInstanceId);
        newEvent.setProcessDefinitionId(processDefinitionId);
        return newEvent;
    }

    public static FlowableEntityEvent createEntityExceptionEvent(FlowableEngineEventType type, Object entity, Throwable cause) {
        ActivitiEntityExceptionEventImpl newEvent = new ActivitiEntityExceptionEventImpl(entity, type, cause);
        ActivitiEventBuilder.populateEventWithCurrentContext(newEvent);
        return newEvent;
    }

    public static FlowableEntityEvent createEntityExceptionEvent(FlowableEngineEventType type, Object entity, Throwable cause, String executionId, String processInstanceId, String processDefinitionId) {
        ActivitiEntityExceptionEventImpl newEvent = new ActivitiEntityExceptionEventImpl(entity, type, cause);
        newEvent.setExecutionId(executionId);
        newEvent.setProcessInstanceId(processInstanceId);
        newEvent.setProcessDefinitionId(processDefinitionId);
        return newEvent;
    }

    public static FlowableActivityEvent createActivityEvent(FlowableEngineEventType type, String activityId, String activityName, String executionId, String processInstanceId, String processDefinitionId, String activityType, String behaviourClass) {
        ActivitiActivityEventImpl newEvent = new ActivitiActivityEventImpl(type);
        newEvent.setActivityId(activityId);
        newEvent.setActivityName(activityName);
        newEvent.setExecutionId(executionId);
        newEvent.setProcessDefinitionId(processDefinitionId);
        newEvent.setProcessInstanceId(processInstanceId);
        newEvent.setActivityType(activityType);
        newEvent.setBehaviorClass(behaviourClass);
        return newEvent;
    }

    public static FlowableActivityCancelledEvent createActivityCancelledEvent(String activityId, String activityName, String executionId, String processInstanceId, String processDefinitionId, String activityType, String behaviourClass, Object cause) {
        ActivitiActivityCancelledEventImpl newEvent = new ActivitiActivityCancelledEventImpl();
        newEvent.setActivityId(activityId);
        newEvent.setActivityName(activityName);
        newEvent.setExecutionId(executionId);
        newEvent.setProcessDefinitionId(processDefinitionId);
        newEvent.setProcessInstanceId(processInstanceId);
        newEvent.setActivityType(activityType);
        newEvent.setBehaviorClass(behaviourClass);
        newEvent.setCause(cause);
        return newEvent;
    }

    public static FlowableCancelledEvent createCancelledEvent(String executionId, String processInstanceId, String processDefinitionId, Object cause) {
        ActivitiProcessCancelledEventImpl newEvent = new ActivitiProcessCancelledEventImpl();
        newEvent.setExecutionId(executionId);
        newEvent.setProcessDefinitionId(processDefinitionId);
        newEvent.setProcessInstanceId(processInstanceId);
        newEvent.setCause(cause);
        return newEvent;
    }

    public static FlowableSignalEvent createSignalEvent(FlowableEngineEventType type, String activityId, String signalName, Object signalData, String executionId, String processInstanceId, String processDefinitionId) {
        ActivitiSignalEventImpl newEvent = new ActivitiSignalEventImpl(type);
        newEvent.setActivityId(activityId);
        newEvent.setExecutionId(executionId);
        newEvent.setProcessDefinitionId(processDefinitionId);
        newEvent.setProcessInstanceId(processInstanceId);
        newEvent.setSignalName(signalName);
        newEvent.setSignalData(signalData);
        return newEvent;
    }

    public static FlowableMessageEvent createMessageEvent(FlowableEngineEventType type, String activityId, String messageName, Object payload, String executionId, String processInstanceId, String processDefinitionId) {
        ActivitiMessageEventImpl newEvent = new ActivitiMessageEventImpl(type);
        newEvent.setActivityId(activityId);
        newEvent.setExecutionId(executionId);
        newEvent.setProcessDefinitionId(processDefinitionId);
        newEvent.setProcessInstanceId(processInstanceId);
        newEvent.setMessageName(messageName);
        newEvent.setMessageData(payload);
        return newEvent;
    }

    public static FlowableErrorEvent createErrorEvent(FlowableEngineEventType type, String activityId, String errorCode, String executionId, String processInstanceId, String processDefinitionId) {
        ActivitiErrorEventImpl newEvent = new ActivitiErrorEventImpl(type);
        newEvent.setActivityId(activityId);
        newEvent.setExecutionId(executionId);
        newEvent.setProcessDefinitionId(processDefinitionId);
        newEvent.setProcessInstanceId(processInstanceId);
        newEvent.setErrorCode(errorCode);
        return newEvent;
    }

    public static FlowableVariableEvent createVariableEvent(FlowableEngineEventType type, String variableName, Object variableValue, VariableType variableType, String taskId, String executionId, String processInstanceId, String processDefinitionId, String variableInstanceId) {
        ActivitiVariableEventImpl newEvent = new ActivitiVariableEventImpl(type);
        newEvent.setVariableName(variableName);
        newEvent.setVariableValue(variableValue);
        newEvent.setVariableType(variableType);
        newEvent.setTaskId(taskId);
        newEvent.setExecutionId(executionId);
        newEvent.setProcessDefinitionId(processDefinitionId);
        newEvent.setProcessInstanceId(processInstanceId);
        newEvent.setVariableInstanceId(variableInstanceId);
        return newEvent;
    }

    public static FlowableIdmMembershipEvent createMembershipEvent(FlowableIdmEventType type, String groupId, String userId) {
        ActivitiMembershipEventImpl newEvent = new ActivitiMembershipEventImpl(type);
        newEvent.setUserId(userId);
        newEvent.setGroupId(groupId);
        return newEvent;
    }

    protected static void populateEventWithCurrentContext(ActivitiEventImpl event) {
        ExecutionContext executionContext;
        boolean extractedFromContext = false;
        if (Context.isExecutionContextActive() && (executionContext = Context.getExecutionContext()) != null) {
            extractedFromContext = true;
            event.setExecutionId(executionContext.getExecution().getId());
            event.setProcessInstanceId(executionContext.getExecution().getProcessInstanceId());
            event.setProcessDefinitionId(executionContext.getExecution().getProcessDefinitionId());
        }
        if (!extractedFromContext && event instanceof FlowableEntityEvent) {
            Object persistedObject = ((FlowableEntityEvent)event).getEntity();
            if (persistedObject instanceof Job) {
                event.setExecutionId(((Job)persistedObject).getExecutionId());
                event.setProcessInstanceId(((Job)persistedObject).getProcessInstanceId());
                event.setProcessDefinitionId(((Job)persistedObject).getProcessDefinitionId());
            } else if (persistedObject instanceof DelegateExecution) {
                event.setExecutionId(((DelegateExecution)persistedObject).getId());
                event.setProcessInstanceId(((DelegateExecution)persistedObject).getProcessInstanceId());
                event.setProcessDefinitionId(((DelegateExecution)persistedObject).getProcessDefinitionId());
            } else if (persistedObject instanceof IdentityLinkEntity) {
                IdentityLinkEntity idLink = (IdentityLinkEntity)persistedObject;
                if (idLink.getProcessDefinitionId() != null) {
                    event.setProcessDefinitionId(idLink.getProcessDefId());
                } else if (idLink.getProcessInstance() != null) {
                    event.setProcessDefinitionId(idLink.getProcessInstance().getProcessDefinitionId());
                    event.setProcessInstanceId(idLink.getProcessInstanceId());
                    event.setExecutionId(idLink.getProcessInstanceId());
                } else if (idLink.getTask() != null) {
                    event.setProcessDefinitionId(idLink.getTask().getProcessDefinitionId());
                    event.setProcessInstanceId(idLink.getTask().getProcessInstanceId());
                    event.setExecutionId(idLink.getTask().getExecutionId());
                }
            } else if (persistedObject instanceof Task) {
                event.setProcessInstanceId(((Task)persistedObject).getProcessInstanceId());
                event.setExecutionId(((Task)persistedObject).getExecutionId());
                event.setProcessDefinitionId(((Task)persistedObject).getProcessDefinitionId());
            } else if (persistedObject instanceof ProcessDefinition) {
                event.setProcessDefinitionId(((ProcessDefinition)persistedObject).getId());
            }
        }
    }
}

