/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cdi.impl;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeShutdown;
import jakarta.enterprise.inject.spi.Extension;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.flowable.cdi.impl.util.FlowableCmmnServices;
import org.flowable.cdi.spi.CmmnEngineLookup;
import org.flowable.cmmn.engine.CmmnEngine;
import org.flowable.common.engine.api.FlowableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowableCmmnExtension
implements Extension {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowableCmmnExtension.class);
    private CmmnEngineLookup cmmnEngineLookup;

    public void afterDeploymentValidation(@Observes AfterDeploymentValidation event, BeanManager beanManager) {
        try {
            LOGGER.info("Initializing flowable-cmmn-cdi.");
            this.lookupCmmnEngine(beanManager);
        }
        catch (Exception e) {
            event.addDeploymentProblem((Throwable)e);
        }
    }

    protected CmmnEngine lookupCmmnEngine(BeanManager beanManager) {
        ServiceLoader<CmmnEngineLookup> cmmnEngineServiceLoader = ServiceLoader.load(CmmnEngineLookup.class);
        Iterator<CmmnEngineLookup> serviceIterator = cmmnEngineServiceLoader.iterator();
        ArrayList<CmmnEngineLookup> discoveredLookups = new ArrayList<CmmnEngineLookup>();
        while (serviceIterator.hasNext()) {
            CmmnEngineLookup serviceInstance = serviceIterator.next();
            discoveredLookups.add(serviceInstance);
        }
        Collections.sort(discoveredLookups, new Comparator<CmmnEngineLookup>(){

            @Override
            public int compare(CmmnEngineLookup o1, CmmnEngineLookup o2) {
                return -1 * Integer.valueOf(o1.getPrecedence()).compareTo(o2.getPrecedence());
            }
        });
        CmmnEngine cmmnEngine = null;
        for (CmmnEngineLookup cmmnEngineLookup : discoveredLookups) {
            cmmnEngine = cmmnEngineLookup.getCmmnEngine();
            if (cmmnEngine != null) {
                this.cmmnEngineLookup = cmmnEngineLookup;
                LOGGER.debug("CmmnEngineLookup service {} returned cmmn engine.", cmmnEngineLookup.getClass());
                break;
            }
            LOGGER.debug("CmmnEngineLookup service {} returned 'null' value.", cmmnEngineLookup.getClass());
        }
        if (this.cmmnEngineLookup == null) {
            throw new FlowableException("Could not find an implementation of the " + CmmnEngineLookup.class.getName() + " service returning a non-null cmmnEngine. Giving up.");
        }
        Bean flowableCmmnServicesBean = (Bean)beanManager.getBeans(FlowableCmmnServices.class, new Annotation[0]).stream().findAny().orElseThrow(() -> new IllegalStateException("CDI BeanManager cannot find an instance of requested type " + FlowableCmmnServices.class.getName()));
        FlowableCmmnServices services = (FlowableCmmnServices)beanManager.getReference(flowableCmmnServicesBean, FlowableCmmnServices.class, beanManager.createCreationalContext((Contextual)flowableCmmnServicesBean));
        services.setCmmnEngine(cmmnEngine);
        return cmmnEngine;
    }

    public void beforeShutdown(@Observes BeforeShutdown event) {
        if (this.cmmnEngineLookup != null) {
            this.cmmnEngineLookup.ungetCmmnEngine();
            this.cmmnEngineLookup = null;
        }
        LOGGER.info("Shutting down flowable-cmmn-cdi");
    }
}

