/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.test;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.flowable.dmn.api.DmnDecisionService;
import org.flowable.dmn.api.DmnHistoryService;
import org.flowable.dmn.api.DmnManagementService;
import org.flowable.dmn.api.DmnRepositoryService;
import org.flowable.dmn.engine.DmnEngine;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.test.DmnConfigurationResource;
import org.flowable.dmn.engine.test.DmnDeployment;
import org.flowable.dmn.engine.test.DmnDeploymentAnnotation;
import org.flowable.dmn.engine.test.DmnDeploymentId;
import org.flowable.dmn.engine.test.DmnTestHelper;
import org.flowable.dmn.engine.test.FlowableDmnTestHelper;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowableDmnExtension
implements ParameterResolver,
BeforeEachCallback,
AfterEachCallback {
    public static final String DEFAULT_CONFIGURATION_RESOURCE = "flowable.dmn.cfg.xml";
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{FlowableDmnExtension.class});
    private static final Set<Class<?>> SUPPORTED_PARAMETERS = new HashSet<Class>(Arrays.asList(DmnEngineConfiguration.class, DmnEngine.class, DmnRepositoryService.class, DmnDecisionService.class, DmnHistoryService.class, DmnManagementService.class));
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void beforeEach(ExtensionContext context) {
        FlowableDmnTestHelper flowableTestHelper = this.getTestHelper(context);
        AnnotationSupport.findAnnotation((Optional)context.getTestMethod(), DmnDeployment.class).ifPresent(deployment -> {
            String deploymentIdFromDeploymentAnnotation = DmnTestHelper.annotationDeploymentSetUp(flowableTestHelper.getDmnEngine(), context.getRequiredTestClass(), context.getRequiredTestMethod(), deployment);
            flowableTestHelper.setDeploymentIdFromDeploymentAnnotation(deploymentIdFromDeploymentAnnotation);
        });
        if (flowableTestHelper.getDeploymentIdFromDeploymentAnnotation() == null) {
            AnnotationSupport.findAnnotation((Optional)context.getTestMethod(), DmnDeploymentAnnotation.class).ifPresent(deployment -> {
                String deploymentIdFromDeploymentAnnotation = DmnTestHelper.annotationDeploymentSetUp(flowableTestHelper.getDmnEngine(), context.getRequiredTestClass(), context.getRequiredTestMethod(), deployment);
                flowableTestHelper.setDeploymentIdFromDeploymentAnnotation(deploymentIdFromDeploymentAnnotation);
            });
        }
    }

    public void afterEach(ExtensionContext context) {
        FlowableDmnTestHelper flowableTestHelper = this.getTestHelper(context);
        DmnEngine dmnEngine = flowableTestHelper.getDmnEngine();
        String deploymentIdFromDeploymentAnnotation = flowableTestHelper.getDeploymentIdFromDeploymentAnnotation();
        if (deploymentIdFromDeploymentAnnotation != null) {
            DmnTestHelper.annotationDeploymentTearDown(dmnEngine, deploymentIdFromDeploymentAnnotation, context.getRequiredTestClass(), context.getRequiredTestMethod().getName());
            flowableTestHelper.setDeploymentIdFromDeploymentAnnotation(null);
        }
        dmnEngine.getDmnEngineConfiguration().getClock().reset();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext context) {
        Class<?> parameterType = parameterContext.getParameter().getType();
        return SUPPORTED_PARAMETERS.contains(parameterType) || FlowableDmnTestHelper.class.equals(parameterType) || parameterContext.isAnnotated(DmnDeploymentId.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext context) {
        DmnEngine dmnEngine;
        FlowableDmnTestHelper flowableTestHelper = this.getTestHelper(context);
        if (parameterContext.isAnnotated(DmnDeploymentId.class)) {
            return flowableTestHelper.getDeploymentIdFromDeploymentAnnotation();
        }
        Class<?> parameterType = parameterContext.getParameter().getType();
        if (parameterType.isInstance(dmnEngine = flowableTestHelper.getDmnEngine())) {
            return dmnEngine;
        }
        if (FlowableDmnTestHelper.class.equals(parameterType)) {
            return flowableTestHelper;
        }
        try {
            return DmnEngine.class.getDeclaredMethod("get" + parameterType.getSimpleName(), new Class[0]).invoke((Object)dmnEngine, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new ParameterResolutionException("Could not find service " + String.valueOf(parameterType), (Throwable)ex);
        }
    }

    protected String getConfigurationResource(ExtensionContext context) {
        return AnnotationSupport.findAnnotation((Optional)context.getTestClass(), DmnConfigurationResource.class).map(DmnConfigurationResource::value).orElse(DEFAULT_CONFIGURATION_RESOURCE);
    }

    protected FlowableDmnTestHelper getTestHelper(ExtensionContext context) {
        return (FlowableDmnTestHelper)this.getStore(context).getOrComputeIfAbsent((Object)context.getRequiredTestClass(), key -> new FlowableDmnTestHelper(this.createDmnEngine(context)), FlowableDmnTestHelper.class);
    }

    protected DmnEngine createDmnEngine(ExtensionContext context) {
        return DmnTestHelper.getDmnEngine(this.getConfigurationResource(context));
    }

    protected ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getRoot().getStore(NAMESPACE);
    }
}

