/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.el;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionVariableFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionVariableFactory.class);

    public static Object getExecutionVariable(String type, Object expressionResult) {
        Object executionVariable;
        block15: {
            if (type == null || expressionResult == null) {
                LOGGER.error("could not create result variable: type {} expression result {}", (Object)type, expressionResult);
                throw new FlowableException("could not create result variable");
            }
            try {
                if (StringUtils.equals((CharSequence)"boolean", (CharSequence)type)) {
                    executionVariable = expressionResult instanceof Boolean ? expressionResult : Boolean.valueOf(expressionResult.toString());
                    break block15;
                }
                if (StringUtils.equals((CharSequence)"string", (CharSequence)type)) {
                    executionVariable = expressionResult instanceof String ? expressionResult : expressionResult.toString();
                    break block15;
                }
                if (StringUtils.equals((CharSequence)"number", (CharSequence)type)) {
                    executionVariable = expressionResult instanceof Double ? expressionResult : (expressionResult instanceof BigDecimal ? (Number)((BigDecimal)expressionResult).doubleValue() : (Number)(expressionResult instanceof BigInteger ? (Number)((BigInteger)expressionResult).longValue() : (Number)Double.valueOf(expressionResult.toString())));
                    break block15;
                }
                if (StringUtils.equals((CharSequence)"date", (CharSequence)type)) {
                    if (expressionResult instanceof Date) {
                        executionVariable = expressionResult;
                    } else if (expressionResult instanceof Instant) {
                        Instant instant = (Instant)expressionResult;
                        executionVariable = Date.from(instant);
                    } else if (expressionResult instanceof LocalDate) {
                        LocalDate localDate = (LocalDate)expressionResult;
                        executionVariable = Date.from(localDate.atStartOfDay().atZone(ZoneOffset.UTC).toInstant());
                    } else if (expressionResult instanceof LocalDateTime) {
                        LocalDateTime localDateTime = (LocalDateTime)expressionResult;
                        executionVariable = Date.from(localDateTime.atZone(ZoneOffset.UTC).toInstant());
                    } else {
                        executionVariable = DateUtil.parseDate((String)expressionResult.toString());
                    }
                    break block15;
                }
                LOGGER.error("could not create result variable: unrecognized mapping type");
                throw new FlowableException("could not create result variable: unrecognized mapping type");
            }
            catch (Exception e) {
                LOGGER.error("could not create result variable", (Throwable)e);
                throw new FlowableException("Could not create execution variable", (Throwable)e);
            }
        }
        return executionVariable;
    }

    public static List<Object> getExecutionVariables(String type, List<Object> expressionResults) {
        if (type == null || expressionResults == null) {
            return null;
        }
        ArrayList<Object> executionVariables = new ArrayList<Object>();
        for (Object expressionResult : expressionResults) {
            executionVariables.add(ExecutionVariableFactory.getExecutionVariable(type, expressionResult));
        }
        return executionVariables;
    }
}

