/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.deployer;

import org.flowable.common.engine.impl.persistence.deploy.DeploymentCache;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.impl.deployer.ParsedDeployment;
import org.flowable.dmn.engine.impl.persistence.deploy.DecisionCacheEntry;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionEntity;
import org.flowable.dmn.engine.impl.persistence.entity.DmnDeploymentEntity;
import org.flowable.dmn.engine.impl.util.CommandContextUtil;
import org.flowable.dmn.model.Decision;
import org.flowable.dmn.model.DecisionService;
import org.flowable.dmn.model.DmnDefinition;

public class CachingAndArtifactsManager {
    public void updateCachingAndArtifacts(ParsedDeployment parsedDeployment) {
        DmnEngineConfiguration dmnEngineConfiguration = CommandContextUtil.getDmnEngineConfiguration();
        DeploymentCache<DecisionCacheEntry> decisionCache = dmnEngineConfiguration.getDeploymentManager().getDecisionCache();
        DmnDeploymentEntity deployment = parsedDeployment.getDeployment();
        for (DecisionEntity decisionEntity : parsedDeployment.getAllDecisions()) {
            DecisionCacheEntry cacheEntry;
            DmnDefinition dmnDefinition = parsedDeployment.getDmnDefinitionForDecision(decisionEntity);
            if (!dmnDefinition.getDecisionServices().isEmpty()) {
                DecisionService decisionService = parsedDeployment.getDecisionServiceForDecisionEntity(decisionEntity);
                cacheEntry = new DecisionCacheEntry(decisionEntity, dmnDefinition, decisionService);
            } else {
                Decision decision = parsedDeployment.getDecisionForDecisionEntity(decisionEntity);
                cacheEntry = new DecisionCacheEntry(decisionEntity, dmnDefinition, decision);
            }
            decisionCache.add(decisionEntity.getId(), (Object)cacheEntry);
            deployment.addDeployedArtifact(decisionEntity);
            deployment.addDecisionCacheEntry(decisionEntity.getId(), cacheEntry);
        }
    }
}

