/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.db;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.impl.db.EngineSchemaManagerLockConfiguration;
import org.flowable.common.engine.impl.db.EngineSqlScriptBasedDbSchemaManager;
import org.flowable.common.engine.impl.db.SchemaManagerLockConfiguration;
import org.flowable.dmn.engine.impl.util.CommandContextUtil;

public class DmnDbSchemaManager
extends EngineSqlScriptBasedDbSchemaManager {
    protected static final String DMN_DB_SCHEMA_LOCK_NAME = "dmnDbSchemaLock";
    protected static final Map<String, String> changeLogVersionMap = Map.ofEntries(Map.entry("1", "6.0.0.5"), Map.entry("2", "6.1.1.0"), Map.entry("3", "6.3.0.0"), Map.entry("4", "6.3.1.0"), Map.entry("5", "6.4.0.0"), Map.entry("6", "6.4.1.3"), Map.entry("7", "6.6.0.0"), Map.entry("8", "6.6.0.0"), Map.entry("9", "6.8.0.0"), Map.entry("10", "7.1.0.0"));

    public DmnDbSchemaManager() {
        super("dmn", (SchemaManagerLockConfiguration)new EngineSchemaManagerLockConfiguration(CommandContextUtil::getDmnEngineConfiguration));
    }

    protected String getEngineVersion() {
        return "7.2.0.2";
    }

    protected String getSchemaVersionPropertyName() {
        return "dmn.schema.version";
    }

    protected String getDbSchemaLockName() {
        return DMN_DB_SCHEMA_LOCK_NAME;
    }

    protected String getEngineTableName() {
        return "ACT_DMN_DECISION";
    }

    protected String getChangeLogTableName() {
        return "ACT_DMN_DATABASECHANGELOG";
    }

    protected String getDbVersionForChangelogVersion(String changeLogVersion) {
        if (StringUtils.isNotEmpty((CharSequence)changeLogVersion) && changeLogVersionMap.containsKey(changeLogVersion)) {
            return changeLogVersionMap.get(changeLogVersion);
        }
        return "5.99.0.0";
    }

    protected String getResourcesRootDirectory() {
        return "org/flowable/dmn/db/";
    }
}

