/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cdi.impl.util;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Set;
import org.flowable.cdi.impl.util.BeanManagerLookup;

public class ProgrammaticBeanLookup {
    public static <T> T lookup(Class<T> clazz, BeanManager bm) {
        Iterator iter = bm.getBeans(clazz, new Annotation[0]).iterator();
        if (!iter.hasNext()) {
            throw new IllegalStateException("CDI BeanManager cannot find an instance of requested type " + clazz.getName());
        }
        Bean bean = (Bean)iter.next();
        CreationalContext ctx = bm.createCreationalContext((Contextual)bean);
        Object dao = bm.getReference(bean, clazz, ctx);
        return (T)dao;
    }

    public static Object lookup(String name, BeanManager bm) {
        Set beans = bm.getBeans(name);
        if (beans.isEmpty()) {
            throw new IllegalStateException("CDI BeanManager cannot find an instance of requested type '" + name + "'");
        }
        Bean bean = bm.resolve(beans);
        CreationalContext ctx = bm.createCreationalContext((Contextual)bean);
        Type type = (Type)bean.getTypes().iterator().next();
        return bm.getReference(bean, type, ctx);
    }

    public static <T> T lookup(Class<T> clazz) {
        BeanManager bm = BeanManagerLookup.getBeanManager();
        return ProgrammaticBeanLookup.lookup(clazz, bm);
    }

    public static Object lookup(String name) {
        BeanManager bm = BeanManagerLookup.getBeanManager();
        return ProgrammaticBeanLookup.lookup(name, bm);
    }
}

