/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cdi.impl.annotation;

import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import org.flowable.cdi.BusinessProcess;
import org.flowable.cdi.FlowableCdiException;
import org.flowable.cdi.annotation.CompleteTask;

@Interceptor
@CompleteTask
public class CompleteTaskInterceptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    BusinessProcess businessProcess;

    @AroundInvoke
    public Object invoke(InvocationContext ctx) throws Exception {
        try {
            Object result = ctx.proceed();
            CompleteTask completeTaskAnnotation = ctx.getMethod().getAnnotation(CompleteTask.class);
            boolean endConversation = completeTaskAnnotation.endConversation();
            this.businessProcess.completeTask(endConversation);
            return result;
        }
        catch (InvocationTargetException e) {
            throw new FlowableCdiException("Error while completing task: " + e.getCause().getMessage(), e.getCause());
        }
    }
}

