/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cdi.impl;

import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.BeforeShutdown;
import jakarta.enterprise.inject.spi.Extension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.flowable.cdi.annotation.BusinessProcessScoped;
import org.flowable.cdi.impl.ProcessDeployer;
import org.flowable.cdi.impl.context.BusinessProcessContext;
import org.flowable.cdi.impl.util.BeanManagerLookup;
import org.flowable.cdi.impl.util.FlowableServices;
import org.flowable.cdi.impl.util.ProgrammaticBeanLookup;
import org.flowable.cdi.spi.ProcessEngineLookup;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.engine.ProcessEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowableExtension
implements Extension {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowableExtension.class);
    private ProcessEngineLookup processEngineLookup;

    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery event) {
        event.addScope(BusinessProcessScoped.class, true, true);
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager manager) {
        BeanManagerLookup.localInstance = manager;
        event.addContext((Context)new BusinessProcessContext(manager));
    }

    public void afterDeploymentValidation(@Observes AfterDeploymentValidation event, BeanManager beanManager) {
        try {
            LOGGER.info("Initializing flowable-cdi.");
            ProcessEngine processEngine = this.lookupProcessEngine(beanManager);
            this.deployProcesses(processEngine);
        }
        catch (Exception e) {
            event.addDeploymentProblem((Throwable)e);
        }
    }

    protected ProcessEngine lookupProcessEngine(BeanManager beanManager) {
        ServiceLoader<ProcessEngineLookup> processEngineServiceLoader = ServiceLoader.load(ProcessEngineLookup.class);
        Iterator<ProcessEngineLookup> serviceIterator = processEngineServiceLoader.iterator();
        ArrayList<ProcessEngineLookup> discoveredLookups = new ArrayList<ProcessEngineLookup>();
        while (serviceIterator.hasNext()) {
            ProcessEngineLookup serviceInstance = serviceIterator.next();
            discoveredLookups.add(serviceInstance);
        }
        Collections.sort(discoveredLookups, new Comparator<ProcessEngineLookup>(){

            @Override
            public int compare(ProcessEngineLookup o1, ProcessEngineLookup o2) {
                return -1 * Integer.valueOf(o1.getPrecedence()).compareTo(o2.getPrecedence());
            }
        });
        ProcessEngine processEngine = null;
        for (ProcessEngineLookup processEngineLookup : discoveredLookups) {
            processEngine = processEngineLookup.getProcessEngine();
            if (processEngine != null) {
                this.processEngineLookup = processEngineLookup;
                LOGGER.debug("ProcessEngineLookup service {} returned process engine.", processEngineLookup.getClass());
                break;
            }
            LOGGER.debug("ProcessEngineLookup service {} returned 'null' value.", processEngineLookup.getClass());
        }
        if (this.processEngineLookup == null) {
            throw new FlowableException("Could not find an implementation of the org.flowable.cdi.spi.ProcessEngineLookup service returning a non-null processEngine. Giving up.");
        }
        FlowableServices services = ProgrammaticBeanLookup.lookup(FlowableServices.class, beanManager);
        services.setProcessEngine(processEngine);
        return processEngine;
    }

    private void deployProcesses(ProcessEngine processEngine) {
        new ProcessDeployer(processEngine).deployProcesses();
    }

    public void beforeShutdown(@Observes BeforeShutdown event) {
        if (this.processEngineLookup != null) {
            this.processEngineLookup.ungetProcessEngine();
            this.processEngineLookup = null;
        }
        LOGGER.info("Shutting down flowable-cdi");
    }
}

