/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cdi;

import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Map;
import org.flowable.cdi.BusinessProcess;
import org.flowable.cdi.annotation.ProcessVariable;
import org.flowable.cdi.impl.ProcessVariableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessVariables {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessVariables.class);
    @Inject
    private BusinessProcess businessProcess;
    @Inject
    private ProcessVariableMap processVariableMap;

    protected String getVariableName(InjectionPoint ip) {
        String variableName = ((ProcessVariable)ip.getAnnotated().getAnnotation(ProcessVariable.class)).value();
        if (variableName.length() == 0) {
            variableName = ip.getMember().getName();
        }
        return variableName;
    }

    @Produces
    @ProcessVariable
    protected Object getProcessVariable(InjectionPoint ip) {
        String processVariableName = this.getVariableName(ip);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Getting process variable '{}' from ProcessInstance[{}].", (Object)processVariableName, (Object)this.businessProcess.getProcessInstanceId());
        }
        return this.businessProcess.getVariable(processVariableName);
    }

    @Produces
    @Named
    protected Map<String, Object> processVariables() {
        return this.processVariableMap;
    }
}

