/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cdi;

import jakarta.enterprise.context.Conversation;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.flowable.cdi.FlowableCdiException;
import org.flowable.cdi.impl.context.ContextAssociationManager;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.Execution;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;

@Named
public class BusinessProcess
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    private ProcessEngine processEngine;
    @Inject
    private ContextAssociationManager associationManager;
    @Inject
    private Instance<Conversation> conversationInstance;

    protected void validateValidUsage() {
        if (Context.getCommandContext() != null) {
            throw new FlowableCdiException("Cannot use this method of the BusinessProcess bean within an active command.");
        }
    }

    public ProcessInstance startProcessById(String processDefinitionId) {
        this.validateValidUsage();
        ProcessInstance instance = this.processEngine.getRuntimeService().startProcessInstanceById(processDefinitionId, this.getAndClearCachedVariables());
        if (!instance.isEnded()) {
            this.setExecution((Execution)instance);
        }
        return instance;
    }

    public ProcessInstance startProcessById(String processDefinitionId, String businessKey) {
        this.validateValidUsage();
        ProcessInstance instance = this.processEngine.getRuntimeService().startProcessInstanceById(processDefinitionId, businessKey, this.getAndClearCachedVariables());
        if (!instance.isEnded()) {
            this.setExecution((Execution)instance);
        }
        return instance;
    }

    public ProcessInstance startProcessById(String processDefinitionId, Map<String, Object> variables) {
        this.validateValidUsage();
        Map<String, Object> cachedVariables = this.getAndClearCachedVariables();
        cachedVariables.putAll(variables);
        ProcessInstance instance = this.processEngine.getRuntimeService().startProcessInstanceById(processDefinitionId, cachedVariables);
        if (!instance.isEnded()) {
            this.setExecution((Execution)instance);
        }
        return instance;
    }

    public ProcessInstance startProcessById(String processDefinitionId, String businessKey, Map<String, Object> variables) {
        this.validateValidUsage();
        Map<String, Object> cachedVariables = this.getAndClearCachedVariables();
        cachedVariables.putAll(variables);
        ProcessInstance instance = this.processEngine.getRuntimeService().startProcessInstanceById(processDefinitionId, businessKey, cachedVariables);
        if (!instance.isEnded()) {
            this.setExecution((Execution)instance);
        }
        return instance;
    }

    public ProcessInstance startProcessByKey(String key) {
        this.validateValidUsage();
        ProcessInstance instance = this.processEngine.getRuntimeService().startProcessInstanceByKey(key, this.getAndClearCachedVariables());
        if (!instance.isEnded()) {
            this.setExecution((Execution)instance);
        }
        return instance;
    }

    public ProcessInstance startProcessByKey(String key, String businessKey) {
        this.validateValidUsage();
        ProcessInstance instance = this.processEngine.getRuntimeService().startProcessInstanceByKey(key, businessKey, this.getAndClearCachedVariables());
        if (!instance.isEnded()) {
            this.setExecution((Execution)instance);
        }
        return instance;
    }

    public ProcessInstance startProcessByKey(String key, Map<String, Object> variables) {
        this.validateValidUsage();
        Map<String, Object> cachedVariables = this.getAndClearCachedVariables();
        cachedVariables.putAll(variables);
        ProcessInstance instance = this.processEngine.getRuntimeService().startProcessInstanceByKey(key, cachedVariables);
        if (!instance.isEnded()) {
            this.setExecution((Execution)instance);
        }
        return instance;
    }

    public ProcessInstance startProcessByKey(String key, String businessKey, Map<String, Object> variables) {
        this.validateValidUsage();
        Map<String, Object> cachedVariables = this.getAndClearCachedVariables();
        cachedVariables.putAll(variables);
        ProcessInstance instance = this.processEngine.getRuntimeService().startProcessInstanceByKey(key, businessKey, cachedVariables);
        if (!instance.isEnded()) {
            this.setExecution((Execution)instance);
        }
        return instance;
    }

    public ProcessInstance startProcessByMessage(String messageName) {
        this.validateValidUsage();
        Map<String, Object> cachedVariables = this.getAndClearCachedVariables();
        ProcessInstance processInstance = this.processEngine.getRuntimeService().startProcessInstanceByMessage(messageName, cachedVariables);
        if (!processInstance.isEnded()) {
            this.setExecution((Execution)processInstance);
        }
        return processInstance;
    }

    public ProcessInstance startProcessByMessage(String messageName, Map<String, Object> processVariables) {
        this.validateValidUsage();
        Map<String, Object> cachedVariables = this.getAndClearCachedVariables();
        cachedVariables.putAll(processVariables);
        ProcessInstance processInstance = this.processEngine.getRuntimeService().startProcessInstanceByMessage(messageName, cachedVariables);
        if (!processInstance.isEnded()) {
            this.setExecution((Execution)processInstance);
        }
        return processInstance;
    }

    public ProcessInstance startProcessByMessage(String messageName, String businessKey, Map<String, Object> processVariables) {
        this.validateValidUsage();
        Map<String, Object> cachedVariables = this.getAndClearCachedVariables();
        cachedVariables.putAll(processVariables);
        ProcessInstance processInstance = this.processEngine.getRuntimeService().startProcessInstanceByMessage(messageName, businessKey, cachedVariables);
        if (!processInstance.isEnded()) {
            this.setExecution((Execution)processInstance);
        }
        return processInstance;
    }

    @Deprecated
    public ProcessInstance startProcessByName(String string) {
        if (Context.getCommandContext() != null) {
            throw new FlowableCdiException("Cannot use startProcessByName in an active command.");
        }
        ProcessDefinition definition = (ProcessDefinition)this.processEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionName(string).singleResult();
        if (definition == null) {
            throw new FlowableObjectNotFoundException("No process definition found for name: " + string, ProcessDefinition.class);
        }
        ProcessInstance instance = this.processEngine.getRuntimeService().startProcessInstanceById(definition.getId(), this.getAndClearCachedVariables());
        if (!instance.isEnded()) {
            this.setExecution((Execution)instance);
        }
        return instance;
    }

    @Deprecated
    public ProcessInstance startProcessByName(String string, Map<String, Object> variables) {
        if (Context.getCommandContext() != null) {
            throw new FlowableCdiException("Cannot use startProcessByName in an active command.");
        }
        ProcessDefinition definition = (ProcessDefinition)this.processEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionName(string).singleResult();
        if (definition == null) {
            throw new FlowableObjectNotFoundException("No process definition found for name: " + string, ProcessDefinition.class);
        }
        Map<String, Object> cachedVariables = this.getAndClearCachedVariables();
        cachedVariables.putAll(variables);
        ProcessInstance instance = this.processEngine.getRuntimeService().startProcessInstanceById(definition.getId(), cachedVariables);
        if (!instance.isEnded()) {
            this.setExecution((Execution)instance);
        }
        return instance;
    }

    public void associateExecutionById(String executionId) {
        Execution execution = (Execution)this.processEngine.getRuntimeService().createExecutionQuery().executionId(executionId).singleResult();
        if (execution == null) {
            throw new FlowableCdiException("Cannot associate execution by id: no execution with id '" + executionId + "' found.");
        }
        this.associationManager.setExecution(execution);
    }

    public boolean isAssociated() {
        return this.associationManager.getExecutionId() != null;
    }

    public void triggerExecution() {
        this.assertAssociated();
        this.processEngine.getRuntimeService().trigger(this.associationManager.getExecutionId(), this.getAndClearCachedVariables());
        this.associationManager.disAssociate();
    }

    public void triggerExecution(boolean endConversation) {
        this.triggerExecution();
        if (endConversation) {
            ((Conversation)this.conversationInstance.get()).end();
        }
    }

    public Task startTask(String taskId) {
        Task currentTask = this.associationManager.getTask();
        if (currentTask != null && currentTask.getId().equals(taskId)) {
            return currentTask;
        }
        Task task = (Task)((TaskQuery)this.processEngine.getTaskService().createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            throw new FlowableCdiException("Cannot resume task with id '" + taskId + "', no such task.");
        }
        this.associationManager.setTask(task);
        this.associateExecutionById(task.getProcessInstanceId());
        return task;
    }

    public Task startTask(String taskId, boolean beginConversation) {
        Conversation conversation;
        if (beginConversation && (conversation = (Conversation)this.conversationInstance.get()).isTransient()) {
            conversation.begin();
        }
        return this.startTask(taskId);
    }

    public void completeTask() {
        this.assertTaskAssociated();
        this.processEngine.getTaskService().complete(this.getTask().getId(), this.getAndClearCachedVariables());
        this.associationManager.disAssociate();
    }

    public void completeTask(boolean endConversation) {
        this.completeTask();
        if (endConversation) {
            ((Conversation)this.conversationInstance.get()).end();
        }
    }

    public boolean isTaskAssociated() {
        return this.associationManager.getTask() != null;
    }

    public <T> T getVariable(String variableName) {
        Object variable = this.associationManager.getVariable(variableName);
        if (variable == null) {
            return null;
        }
        return (T)variable;
    }

    public void setVariable(String variableName, Object value) {
        this.associationManager.setVariable(variableName, value);
    }

    public void setTask(Task task) {
        this.startTask(task.getId());
    }

    public void setTaskId(String taskId) {
        this.startTask(taskId);
    }

    public void setExecution(Execution execution) {
        this.associateExecutionById(execution.getId());
    }

    protected void setExecutionId(String executionId) {
        this.associateExecutionById(executionId);
    }

    public String getProcessInstanceId() {
        Execution execution = this.associationManager.getExecution();
        return execution != null ? execution.getProcessInstanceId() : null;
    }

    public String getTaskId() {
        Task task = this.getTask();
        return task != null ? task.getId() : null;
    }

    public Task getTask() {
        return this.associationManager.getTask();
    }

    public Execution getExecution() {
        return this.associationManager.getExecution();
    }

    public String getExecutionId() {
        Execution e = this.getExecution();
        return e != null ? e.getId() : null;
    }

    public ProcessInstance getProcessInstance() {
        Execution execution = this.getExecution();
        if (execution != null && !execution.getProcessInstanceId().equals(execution.getId())) {
            return (ProcessInstance)this.processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(execution.getProcessInstanceId()).singleResult();
        }
        return (ProcessInstance)execution;
    }

    protected void assertAssociated() {
        if (this.associationManager.getExecution() == null) {
            throw new FlowableCdiException("No execution associated. Call businessProcess.associateExecutionById() or businessProcess.startTask() first.");
        }
    }

    protected void assertTaskAssociated() {
        if (this.associationManager.getTask() == null) {
            throw new FlowableCdiException("No task associated. Call businessProcess.startTask() first.");
        }
    }

    protected Map<String, Object> getCachedVariables() {
        return this.associationManager.getCachedVariables();
    }

    protected Map<String, Object> getAndClearCachedVariables() {
        Map<String, Object> beanStore = this.getCachedVariables();
        HashMap<String, Object> copy = new HashMap<String, Object>(beanStore);
        beanStore.clear();
        return copy;
    }
}

