/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.autodeployment;

import java.io.IOException;
import java.util.zip.ZipInputStream;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.DeploymentBuilder;
import org.activiti.spring.autodeployment.AbstractAutoDeploymentStrategy;
import org.springframework.core.io.Resource;

public class SingleResourceAutoDeploymentStrategy
extends AbstractAutoDeploymentStrategy {
    public static final String DEPLOYMENT_MODE = "single-resource";

    @Override
    protected String getDeploymentMode() {
        return DEPLOYMENT_MODE;
    }

    @Override
    public void deployResources(String deploymentNameHint, Resource[] resources, RepositoryService repositoryService) {
        for (Resource resource : resources) {
            String resourceName = this.determineResourceName(resource);
            DeploymentBuilder deploymentBuilder = repositoryService.createDeployment().enableDuplicateFiltering().name(resourceName);
            try {
                if (resourceName.endsWith(".bar") || resourceName.endsWith(".zip") || resourceName.endsWith(".jar")) {
                    deploymentBuilder.addZipInputStream(new ZipInputStream(resource.getInputStream()));
                } else {
                    deploymentBuilder.addInputStream(resourceName, resource.getInputStream());
                }
            }
            catch (IOException e) {
                throw new ActivitiException("couldn't auto deploy resource '" + String.valueOf(resource) + "': " + e.getMessage(), (Throwable)e);
            }
            deploymentBuilder.deploy();
        }
    }
}

