/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.flowable.app.api.AppRepositoryService;
import org.flowable.app.api.repository.AppDeployment;
import org.flowable.app.api.repository.AppDeploymentQuery;
import org.flowable.app.rest.AppRestApiInterceptor;
import org.flowable.app.rest.AppRestResponseFactory;
import org.flowable.app.rest.service.api.repository.AppDeploymentResourceResponse;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.rest.resolver.ContentTypeResolver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"App Deployments"}, description="Manage App Deployment", authorizations={@Authorization(value="basicAuth")})
public class AppDeploymentResourceResource {
    @Autowired
    protected AppRestResponseFactory restResponseFactory;
    @Autowired
    protected ContentTypeResolver contentTypeResolver;
    @Autowired
    protected AppRepositoryService repositoryService;
    @Autowired(required=false)
    protected AppRestApiInterceptor restApiInterceptor;

    @ApiOperation(value="Get a deployment resource", tags={"App Deployments"}, notes="Replace ** by ResourceId")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates both deployment and resource have been found and the resource has been returned."), @ApiResponse(code=404, message="Indicates the requested deployment was not found or there is no resource with the given id present in the deployment. The status-description contains additional information.")})
    @GetMapping(value={"/app-repository/deployments/{deploymentId}/resources/**"}, produces={"application/json"})
    public AppDeploymentResourceResponse getDeploymentResource(@ApiParam(name="deploymentId") @PathVariable(value="deploymentId") String deploymentId, HttpServletRequest request) {
        AppDeployment deployment = (AppDeployment)((AppDeploymentQuery)this.repositoryService.createDeploymentQuery().deploymentId(deploymentId)).singleResult();
        if (deployment == null) {
            throw new FlowableObjectNotFoundException("Could not find a deployment with id '" + deploymentId + "'.");
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessDeploymentById(deployment);
        }
        String pathInfo = request.getPathInfo();
        String resourceName = pathInfo.replace("/app-repository/deployments/" + deploymentId + "/resources/", "");
        List resourceList = this.repositoryService.getDeploymentResourceNames(deploymentId);
        if (resourceList.contains(resourceName)) {
            return this.restResponseFactory.createDeploymentResourceResponse(deploymentId, resourceName, this.contentTypeResolver.resolveContentType(resourceName));
        }
        throw new FlowableObjectNotFoundException("Could not find a resource with id '" + resourceName + "' in deployment '" + deploymentId + "'.");
    }
}

