/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import org.flowable.app.api.AppRepositoryService;
import org.flowable.app.api.repository.AppDeployment;
import org.flowable.app.api.repository.AppDeploymentQuery;
import org.flowable.app.rest.AppRestApiInterceptor;
import org.flowable.app.rest.AppRestResponseFactory;
import org.flowable.app.rest.service.api.repository.AppDeploymentResourceResponse;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.rest.resolver.ContentTypeResolver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"App Deployments"}, description="Manage App Deployment", authorizations={@Authorization(value="basicAuth")})
public class AppDeploymentResourceCollectionResource {
    @Autowired
    protected AppRestResponseFactory appResponseFactory;
    @Autowired
    protected ContentTypeResolver contentTypeResolver;
    @Autowired
    protected AppRepositoryService repositoryService;
    @Autowired(required=false)
    protected AppRestApiInterceptor restApiInterceptor;

    @ApiOperation(value="List resources in a deployment", tags={"App Deployments"}, nickname="listDeploymentResources", notes="The dataUrl property in the resulting JSON for a single resource contains the actual URL to use for retrieving the binary resource.")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the deployment was found and the resource list has been returned."), @ApiResponse(code=404, message="Indicates the requested deployment was not found.")})
    @GetMapping(value={"/app-repository/deployments/{deploymentId}/resources"}, produces={"application/json"})
    public List<AppDeploymentResourceResponse> getDeploymentResources(@ApiParam(name="deploymentId") @PathVariable String deploymentId) {
        AppDeployment deployment = (AppDeployment)((AppDeploymentQuery)this.repositoryService.createDeploymentQuery().deploymentId(deploymentId)).singleResult();
        if (deployment == null) {
            throw new FlowableObjectNotFoundException("Could not find a deployment with id '" + deploymentId + "'.", AppDeployment.class);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessDeploymentById(deployment);
        }
        List resourceList = this.repositoryService.getDeploymentResourceNames(deploymentId);
        return this.appResponseFactory.createDeploymentResourceResponseList(deploymentId, resourceList, this.contentTypeResolver);
    }
}

