/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.engine.test;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.Set;
import org.flowable.app.api.AppManagementService;
import org.flowable.app.api.AppRepositoryService;
import org.flowable.app.engine.AppEngine;
import org.flowable.app.engine.AppEngineConfiguration;
import org.flowable.app.engine.test.AppConfigurationResource;
import org.flowable.app.engine.test.AppDeployment;
import org.flowable.app.engine.test.AppDeploymentId;
import org.flowable.app.engine.test.FlowableAppTestHelper;
import org.flowable.app.engine.test.impl.AppTestHelper;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;

public class FlowableAppExtension
implements ParameterResolver,
BeforeEachCallback,
AfterEachCallback {
    public static final String DEFAULT_CONFIGURATION_RESOURCE = "flowable.app.cfg.xml";
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{FlowableAppExtension.class});
    private static final Set<Class<?>> SUPPORTED_PARAMETER_TYPES = Set.of(AppEngine.class, AppEngineConfiguration.class, AppRepositoryService.class, AppManagementService.class);

    public void beforeEach(ExtensionContext context) {
        FlowableAppTestHelper testHelper = this.getTestHelper(context);
        AnnotationSupport.findAnnotation((Optional)context.getTestMethod(), AppDeployment.class).ifPresent(deployment -> {
            String deploymentId = AppTestHelper.annotationDeploymentSetUp(testHelper.getAppEngine(), context.getRequiredTestClass(), context.getRequiredTestMethod(), deployment);
            testHelper.setDeploymentIdFromDeploymentAnnotation(deploymentId);
        });
    }

    public void afterEach(ExtensionContext context) {
        FlowableAppTestHelper testHelper = this.getTestHelper(context);
        String deploymentId = testHelper.getDeploymentIdFromDeploymentAnnotation();
        if (deploymentId != null) {
            testHelper.getAppEngine().getAppRepositoryService().deleteDeployment(deploymentId, true);
            testHelper.setDeploymentIdFromDeploymentAnnotation(null);
        }
        testHelper.getAppEngine().getAppEngineConfiguration().getClock().reset();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> parameterType = parameterContext.getParameter().getType();
        return SUPPORTED_PARAMETER_TYPES.contains(parameterType) || AnnotationSupport.isAnnotated((AnnotatedElement)parameterContext.getParameter(), AppDeploymentId.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        AppEngine appEngine;
        FlowableAppTestHelper testHelper = this.getTestHelper(extensionContext);
        if (parameterContext.isAnnotated(AppDeploymentId.class)) {
            return testHelper.getDeploymentIdFromDeploymentAnnotation();
        }
        Class<?> parameterType = parameterContext.getParameter().getType();
        if (parameterType.isInstance(appEngine = testHelper.getAppEngine())) {
            return appEngine;
        }
        try {
            return AppEngine.class.getDeclaredMethod("get" + parameterType.getSimpleName(), new Class[0]).invoke((Object)appEngine, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ParameterResolutionException("Could not find service " + String.valueOf(parameterType), (Throwable)e);
        }
    }

    protected String getConfigurationResource(ExtensionContext context) {
        return AnnotationSupport.findAnnotation((Optional)context.getTestClass(), AppConfigurationResource.class).map(AppConfigurationResource::value).orElse(DEFAULT_CONFIGURATION_RESOURCE);
    }

    protected FlowableAppTestHelper getTestHelper(ExtensionContext context) {
        return (FlowableAppTestHelper)this.getStore(context).getOrComputeIfAbsent((Object)context.getRequiredTestClass(), key -> new FlowableAppTestHelper(this.createAppEngine(context)), FlowableAppTestHelper.class);
    }

    protected AppEngine createAppEngine(ExtensionContext context) {
        return AppTestHelper.getAppEngine(this.getConfigurationResource(context));
    }

    protected ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getRoot().getStore(NAMESPACE);
    }
}

