/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.webservice;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentMap;
import javax.xml.namespace.QName;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;
import org.apache.cxf.message.Message;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.engine.delegate.BpmnError;
import org.flowable.engine.impl.webservice.SyncWebServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CxfWebServiceClient
implements SyncWebServiceClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(CxfWebServiceClient.class);
    protected Client client;

    public CxfWebServiceClient(String wsdl) {
        JaxWsDynamicClientFactory dcf = JaxWsDynamicClientFactory.newInstance();
        try {
            URL xjcBindingUrl;
            Enumeration<URL> xjcBindingUrls = Thread.currentThread().getContextClassLoader().getResources("flowable-bindings.xjc");
            if (xjcBindingUrls.hasMoreElements()) {
                xjcBindingUrl = xjcBindingUrls.nextElement();
                if (xjcBindingUrls.hasMoreElements()) {
                    throw new FlowableException("Several JAXB binding definitions found for flowable-cxf: flowable-bindings.xjc");
                }
            } else {
                throw new FlowableException("The JAXB binding definitions are not found for flowable-cxf: flowable-bindings.xjc");
            }
            this.client = dcf.createClient(wsdl, Arrays.asList(xjcBindingUrl.toString()));
            this.client.getRequestContext().put("org.apache.cxf.stax.force-start-document", Boolean.TRUE);
        }
        catch (IOException e) {
            throw new FlowableException("An error occurs creating a web-service client for WSDL '" + wsdl + "'.", (Throwable)e);
        }
    }

    public Object[] send(String methodName, Object[] arguments, ConcurrentMap<QName, URL> overridenEndpointAddresses) throws Exception {
        try {
            URL newEndpointAddress = null;
            if (overridenEndpointAddresses != null) {
                newEndpointAddress = (URL)overridenEndpointAddresses.get(this.client.getEndpoint().getEndpointInfo().getName());
            }
            if (newEndpointAddress != null) {
                this.client.getRequestContext().put(Message.ENDPOINT_ADDRESS, newEndpointAddress.toExternalForm());
            }
            return this.client.invoke(methodName, arguments);
        }
        catch (Fault e) {
            LOGGER.debug("Technical error calling WS", (Throwable)e);
            throw new FlowableException(e.getMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            LOGGER.debug("Technical error calling WS", (Throwable)e);
            throw new FlowableException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.debug("Business error calling WS", (Throwable)e);
            throw new BpmnError(e.getClass().getName(), e.getMessage());
        }
    }
}

