/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.camel;

import org.apache.camel.CamelContext;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.commons.lang3.StringUtils;
import org.flowable.camel.CamelBehavior;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.spring.SpringProcessEngineConfiguration;

public abstract class SpringCamelBehavior
extends CamelBehavior {
    private static final long serialVersionUID = 1L;
    protected final Object contextLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CamelContext getCamelContext(DelegateExecution execution, boolean isV5Execution) {
        String camelContextValue = this.getStringFromField(this.camelContext, execution);
        if (StringUtils.isEmpty((CharSequence)camelContextValue)) {
            if (this.camelContextObj != null) {
                return this.camelContextObj;
            }
            Object object = this.contextLock;
            synchronized (object) {
                if (this.camelContextObj != null) {
                    return this.camelContextObj;
                }
                this.camelContextObj = this.resolveCamelContext(camelContextValue, isV5Execution);
            }
            return this.camelContextObj;
        }
        return this.resolveCamelContext(camelContextValue, isV5Execution);
    }

    protected CamelContext resolveCamelContext(String camelContextValue, boolean isV5Execution) {
        ProcessEngineConfigurationImpl engineConfiguration = Context.getProcessEngineConfiguration();
        if (isV5Execution) {
            Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
            return (CamelContext)compatibilityHandler.getCamelContextObject(camelContextValue);
        }
        try {
            Object ctx;
            SpringProcessEngineConfiguration springConfiguration = (SpringProcessEngineConfiguration)engineConfiguration;
            if (StringUtils.isEmpty((CharSequence)camelContextValue)) {
                camelContextValue = springConfiguration.getDefaultCamelContext();
            }
            if (!((ctx = springConfiguration.getApplicationContext().getBean(camelContextValue)) instanceof SpringCamelContext)) {
                throw new FlowableException("Could not find CamelContext named " + camelContextValue + ".");
            }
            return (SpringCamelContext)ctx;
        }
        catch (Exception e) {
            throw new FlowableException("Expecting a SpringProcessEngineConfiguration for the Camel module.", (Throwable)e);
        }
    }
}

