/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.camel;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.commons.lang3.StringUtils;
import org.flowable.camel.FlowableConsumer;
import org.flowable.camel.FlowableProducer;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.engine.IdentityService;
import org.flowable.engine.ManagementService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;

public class FlowableEndpoint
extends DefaultEndpoint {
    protected IdentityService identityService;
    protected RuntimeService runtimeService;
    protected RepositoryService repositoryService;
    protected ManagementService managementService;
    protected FlowableConsumer flowableConsumer;
    protected boolean copyVariablesToProperties;
    protected boolean copyVariablesToBodyAsMap;
    protected boolean copyCamelBodyToBody;
    protected String copyVariablesFromProperties;
    protected String copyVariablesFromHeader;
    protected boolean copyCamelBodyToBodyAsString;
    protected String processInitiatorHeaderName;
    protected Map<String, Object> returnVarMap = new HashMap<String, Object>();
    protected long timeout = 5000L;
    protected int timeResolution = 100;

    public FlowableEndpoint(String uri, CamelContext camelContext) {
        this.setCamelContext(camelContext);
        this.setEndpointUri(uri);
    }

    public void process(Exchange ex) throws Exception {
        if (this.flowableConsumer == null) {
            throw new FlowableException("Consumer not defined for " + this.getEndpointUri());
        }
        this.flowableConsumer.getProcessor().process(ex);
    }

    public Producer createProducer() throws Exception {
        FlowableProducer producer = new FlowableProducer(this, this.getTimeout(), this.getTimeResolution());
        producer.setRuntimeService(this.runtimeService);
        producer.setIdentityService(this.identityService);
        producer.setRepositoryService(this.repositoryService);
        producer.setManagementService(this.managementService);
        return producer;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new FlowableConsumer(this, processor);
    }

    protected void addConsumer(FlowableConsumer consumer) {
        if (this.flowableConsumer != null) {
            throw new FlowableException("Consumer already defined for " + this.getEndpointUri() + "!");
        }
        this.flowableConsumer = consumer;
    }

    protected void removeConsumer() {
        this.flowableConsumer = null;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }

    public void setRuntimeService(RuntimeService runtimeService) {
        this.runtimeService = runtimeService;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public void setManagementService(ManagementService managementService) {
        this.managementService = managementService;
    }

    public boolean isCopyVariablesToProperties() {
        return this.copyVariablesToProperties;
    }

    public void setCopyVariablesToProperties(boolean copyVariablesToProperties) {
        this.copyVariablesToProperties = copyVariablesToProperties;
    }

    public boolean isCopyCamelBodyToBody() {
        return this.copyCamelBodyToBody;
    }

    public void setCopyCamelBodyToBody(boolean copyCamelBodyToBody) {
        this.copyCamelBodyToBody = copyCamelBodyToBody;
    }

    public boolean isCopyVariablesToBodyAsMap() {
        return this.copyVariablesToBodyAsMap;
    }

    public void setCopyVariablesToBodyAsMap(boolean copyVariablesToBodyAsMap) {
        this.copyVariablesToBodyAsMap = copyVariablesToBodyAsMap;
    }

    public String getCopyVariablesFromProperties() {
        return this.copyVariablesFromProperties;
    }

    public void setCopyVariablesFromProperties(String copyVariablesFromProperties) {
        this.copyVariablesFromProperties = copyVariablesFromProperties;
    }

    public String getCopyVariablesFromHeader() {
        return this.copyVariablesFromHeader;
    }

    public void setCopyVariablesFromHeader(String copyVariablesFromHeader) {
        this.copyVariablesFromHeader = copyVariablesFromHeader;
    }

    public boolean isCopyCamelBodyToBodyAsString() {
        return this.copyCamelBodyToBodyAsString;
    }

    public void setCopyCamelBodyToBodyAsString(boolean copyCamelBodyToBodyAsString) {
        this.copyCamelBodyToBodyAsString = copyCamelBodyToBodyAsString;
    }

    public boolean isSetProcessInitiator() {
        return StringUtils.isNotEmpty((CharSequence)this.getProcessInitiatorHeaderName());
    }

    public Map<String, Object> getReturnVarMap() {
        return this.returnVarMap;
    }

    public void setReturnVarMap(Map<String, Object> returnVarMap) {
        this.returnVarMap = returnVarMap;
    }

    public String getProcessInitiatorHeaderName() {
        return this.processInitiatorHeaderName;
    }

    public void setProcessInitiatorHeaderName(String processInitiatorHeaderName) {
        this.processInitiatorHeaderName = processInitiatorHeaderName;
    }

    public boolean isLenientProperties() {
        return true;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public int getTimeResolution() {
        return this.timeResolution;
    }
}

