/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.variable;

import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.variable.VariableLengthVerifier;
import org.flowable.variable.api.types.ValueFields;
import org.flowable.variable.api.types.VariableType;

public class MaxAllowedLengthVariableVerifier
implements VariableLengthVerifier {
    protected final int maxAllowedLength;

    public MaxAllowedLengthVariableVerifier(int maxAllowedLength) {
        if (maxAllowedLength <= 0) {
            throw new FlowableIllegalArgumentException("The maximum allowed length must be greater than 0");
        }
        this.maxAllowedLength = maxAllowedLength;
    }

    @Override
    public void verifyLength(int length, ValueFields valueFields, VariableType variableType) {
        if (length > this.maxAllowedLength) {
            String scopeType;
            String scopeId;
            if (StringUtils.isNotEmpty((CharSequence)valueFields.getTaskId())) {
                scopeId = valueFields.getTaskId();
                scopeType = "task";
            } else if (StringUtils.isNotEmpty((CharSequence)valueFields.getProcessInstanceId())) {
                scopeId = valueFields.getProcessInstanceId();
                scopeType = "bpmn";
            } else {
                scopeId = valueFields.getScopeId();
                scopeType = valueFields.getScopeType();
            }
            throw new FlowableIllegalArgumentException("The length of the " + variableType.getTypeName() + " value exceeds the maximum allowed length of " + this.maxAllowedLength + " characters. Current length: " + length + ", for variable: " + valueFields.getName() + " in scope " + scopeType + " with id " + scopeId);
        }
    }
}

