/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.rest.variable;

import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.rest.variable.EngineRestVariable;
import org.flowable.common.rest.variable.RestVariableConverter;

public class LocalDateTimeRestVariableConverter
implements RestVariableConverter {
    @Override
    public String getRestTypeName() {
        return "localDateTime";
    }

    @Override
    public Class<?> getVariableType() {
        return LocalDateTime.class;
    }

    @Override
    public Object getVariableValue(EngineRestVariable result) {
        if (result.getValue() != null) {
            if (!(result.getValue() instanceof String)) {
                throw new FlowableIllegalArgumentException("Converter can only convert string to localDateTime");
            }
            try {
                return LocalDateTime.parse((String)result.getValue());
            }
            catch (DateTimeParseException e) {
                throw new FlowableIllegalArgumentException("The given variable value is not a localDateTime: '" + String.valueOf(result.getValue()) + "'", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void convertVariableValue(Object variableValue, EngineRestVariable result) {
        if (variableValue != null) {
            if (!(variableValue instanceof LocalDateTime)) {
                throw new FlowableIllegalArgumentException("Converter can only convert localDateTime");
            }
            result.setValue(variableValue.toString());
        } else {
            result.setValue(null);
        }
    }
}

