/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.rest.variable;

import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.rest.variable.EngineRestVariable;
import org.flowable.common.rest.variable.RestVariableConverter;

public class IntegerRestVariableConverter
implements RestVariableConverter {
    @Override
    public String getRestTypeName() {
        return "integer";
    }

    @Override
    public Class<?> getVariableType() {
        return Integer.class;
    }

    @Override
    public Object getVariableValue(EngineRestVariable result) {
        if (result.getValue() != null) {
            if (!(result.getValue() instanceof Number)) {
                throw new FlowableIllegalArgumentException("Converter can only convert integers");
            }
            return ((Number)result.getValue()).intValue();
        }
        return null;
    }

    @Override
    public void convertVariableValue(Object variableValue, EngineRestVariable result) {
        if (variableValue != null) {
            if (!(variableValue instanceof Integer)) {
                throw new FlowableIllegalArgumentException("Converter can only convert integers");
            }
            result.setValue(variableValue);
        } else {
            result.setValue(null);
        }
    }
}

