# 🎮 MuOnline Season 6 Server - 32BitsArg Edition

<div align="center">
  <img src="https://i.imgur.com/8KjQx2L.jpg" alt="MuOnline Season 6" width="600" style="border-radius: 10px;">
  
  ![MuOnline](https://img.shields.io/badge/MuOnline-Season%206-blue)
  ![Version](https://img.shields.io/badge/Version-Louis%20Update%2031-green)
  ![Status](https://img.shields.io/badge/Status-Semi%20Configurado-yellow)
  ![Author](https://img.shields.io/badge/Author-32BitsArg-red)
</div>

## 📋 Descripción

Servidor de **MuOnline Season 6** desarrollado por **32BitsArg** utilizando los archivos liberados de **Louis Update 31**. Este servidor incluye todas las características modernas de MuOnline con eventos personalizados, sistema de cash shop, rankings avanzados y mucho más.

> ⚠️ **Estado Actual**: El servidor está **semi-configurado** y requiere configuración adicional antes de poder ser usado en producción.

## ✨ Características Principales

### 🎯 Sistema de Servidor
- **Season 6** completo con todas las características
- **Múltiples servidores**: GameServer principal y GameServerCS (Castle Siege)
- **Sistema anti-hack** integrado (MHPServer)
- **Soporte multi-idioma** (Español, Inglés, Portugués)
- **Máximo 100 usuarios** por servidor

### 🛡️ Servicios Incluidos
- **ConnectServer** - Gestión de conexiones
- **JoinServer** - Autenticación de usuarios
- **DataServer** - Base de datos
- **GameServer** - Servidor principal de juego
- **GameServerCS** - Servidor de Castle Siege
- **MHPServer** - Protección anti-hack

### 🎮 Características de Juego

<div align="center">
  <img src="https://i.imgur.com/5KjQx2L.jpg" alt="MuOnline Gameplay" width="500" style="border-radius: 8px;">
</div>

- **Sistema de Cash Shop** completo
- **Eventos personalizados**: Blood Castle, Devil Square, Chaos Castle, etc.
- **Sistema de rankings** avanzado
- **Custom NPCs** y quests
- **Sistema de pets** y wings
- **Arena personalizada**
- **Sistema de VIP**
- **Lucky Wheel** (ruleta de la suerte)
- **Item Bank** personalizado

## 🚀 Instalación y Configuración

### Requisitos del Sistema
- **Windows 7/8/10/11** (32-bit o 64-bit)
- **SQL Server** (2008 o superior) - Recomiendo SQL Server 2019+
- **Visual C++ Redistributable** (incluido en el paquete)
- **Mínimo 4GB RAM** (8GB recomendado)
- **2GB espacio libre** en disco

### ⚠️ Estado de Configuración Actual

**Lo que está configurado:**
- Estructura básica de servidores
- Archivos de configuración base
- Scripts SQL de actualización
- Herramientas de edición

**Lo que falta configurar:**
- Conexiones de base de datos específicas
- IPs y puertos personalizados
- Configuración de eventos personalizados
- Ajustes de rates y experiencia
- Configuración de cash shop
- Personalización de NPCs y quests

### Pasos de Instalación

1. **Preparar Base de Datos**
   ```sql
   -- Restaurar desde el backup incluido
   -- Ubicación: DB/Backup Season 6 update 31.bak
   -- Ejecutar todos los scripts SQL en orden
   ```

2. **Configurar ODBC**
   ```cmd
   # Ejecutar según tu sistema:
   DB/MuOnline.reg     # Sistemas 32-bit
   DB/MuOnline64.reg   # Sistemas 64-bit
   ```

3. **Personalizar Configuración**
   - Modificar IPs en archivos `.ini` y `.dat`
   - Ajustar puertos si es necesario
   - Configurar conexión a tu base de datos
   - Personalizar eventos y rates

4. **Iniciar Servidores** (en orden)
   ```
   1. DataServer.exe
   2. JoinServer.exe  
   3. ConnectServer.exe
   4. GameServer.exe
   5. GameServerCS.exe
   6. MHPServer.exe
   ```

## ⚙️ Configuración Detallada

### Archivos Principales a Modificar

| Servidor | Archivo | ¿Configurado? | Descripción |
|----------|---------|---------------|-------------|
| ConnectServer | `ConnectServer.ini` | ✅ Básico | Configuración de conexiones |
| JoinServer | `JoinServer.ini` | ⚠️ Parcial | Autenticación y puertos |
| DataServer | `DataServer.ini` | ❌ Pendiente | Conexión a base de datos |
| GameServer | `GameServerInfo - Common.dat` | ⚠️ Parcial | Configuración principal |

### Puertos Actuales (Modificar según necesidad)
- **ConnectServer**: 44405 (TCP), 55557 (UDP)
- **JoinServer**: 55970
- **DataServer**: 55960
- **GameServer**: 55901
- **GameServerCS**: 55919

### 🔧 Configuraciones Pendientes

**Base de Datos:**
- Configurar ODBC con tu instancia de SQL Server
- Ajustar credenciales en archivos `.ini`
- Verificar conexión antes de iniciar servidores

**Red:**
- Cambiar IPs de `127.0.0.1` a tu IP pública/local
- Verificar que los puertos estén disponibles
- Configurar firewall si es necesario

## 🛠️ Herramientas Incluidas

<div align="center">
  <img src="https://i.imgur.com/9KjQx2L.jpg" alt="MuOnline Tools" width="500" style="border-radius: 8px;">
</div>

### 🎨 Editores y Utilidades
- **MuEditor EX603** - Editor completo de items y configuración
- **CashShop Editor by Louis** - Editor avanzado de tienda de cash
- **MAIN_INFO v31** - Editor de información principal del cliente
- **StartUp Manager** - Gestor automático de inicio de servidores

### 📊 Base de Datos
- **57 archivos SQL** de actualización (Updates 2-31)
- Scripts de procedimientos almacenados personalizados
- Tablas para eventos personalizados
- Sistema completo de rankings y estadísticas
- Backup completo de la base de datos Season 6

## 📁 Estructura del Proyecto

```
MuServer_Season_6_Update_31-FREE/
├── ConnectServer/          # Servidor de conexiones
├── DataServer/            # Servidor de base de datos
├── JoinServer/            # Servidor de autenticación
├── GameServer/            # Servidor principal
├── GameServerCS/          # Servidor Castle Siege
├── MHPServer/             # Protección anti-hack
├── Data/                  # Archivos de configuración
│   ├── Custom/            # Configuraciones personalizadas
│   ├── Event/             # Eventos del servidor
│   ├── Item/              # Items y drops
│   ├── Monster/           # Monstruos y AI
│   └── Shop/              # Tiendas NPC
├── DB/                    # Archivos de base de datos
├── SQL/                   # Scripts SQL
├── Tools/                 # Herramientas de edición
└── StartUp/               # Gestor de inicio
```

## 🎯 Eventos Disponibles

<div align="center">
  <img src="https://i.imgur.com/7KjQx2L.jpg" alt="MuOnline Events" width="600" style="border-radius: 8px;">
</div>

- **Blood Castle** - Castillo de sangre
- **Devil Square** - Plaza del diablo
- **Chaos Castle** - Castillo del caos
- **Crywolf** - Lobo llorón
- **Kanturu** - Kanturu
- **Illusion Temple** - Templo de la ilusión
- **Castle Deep** - Castillo profundo
- **Battle Royale** - Batalla real
- **Team vs Team** - Equipo vs Equipo
- **Guild vs Guild** - Gremio vs Gremio

## 🔧 Personalización

### Archivos de Configuración Personalizada
- `CustomArena.txt` - Configuración de arena
- `CustomEventDrop.txt` - Drops de eventos
- `CustomMonster.txt` - Monstruos personalizados
- `CustomQuest.txt` - Quests personalizadas
- `CustomRanking.txt` - Sistema de rankings
- `CustomWing.txt` - Alas personalizadas

## 📞 Información Técnica

### Detalles del Servidor
- **Nombre**: MuEMU (32BitsArg Edition)
- **Versión**: 1.04.05
- **Serial**: TbYehR2hFUPBKgZj
- **Zona Horaria**: UTC+3
- **Idioma Global**: Español (3)
- **Máximo Usuarios**: 100 por servidor

### 📊 Sistema de Logs
Cada servidor genera logs detallados en sus carpetas `LOG/`:
- **Chat Logs** - Conversaciones y mensajes
- **Command Logs** - Comandos ejecutados por usuarios
- **Trade Logs** - Transacciones entre jugadores
- **Connection Logs** - Conexiones y desconexiones
- **Hack Logs** - Detección de hacks y exploits
- **Cash Shop Logs** - Compras en tienda de cash

## 📄 Licencia y Créditos

Este servidor utiliza los archivos liberados de **Louis Update 31** para MuOnline Season 6.

**Desarrollado por:** 32BitsArg  
**Base:** Louis Update 31 Files  
**Versión:** Season 6  

## ⚠️ Notas Importantes

**Antes de usar el servidor:**
- Instala y configura **SQL Server** correctamente
- Configura los **ODBC** antes de iniciar cualquier servidor
- Verifica que todos los **puertos** estén disponibles
- **IMPORTANTE**: El servidor está semi-configurado, requiere configuración adicional
- Revisa los logs regularmente para detectar problemas
- Haz backup de tu base de datos antes de hacer cambios

**Recomendaciones:**
- Usa SQL Server 2019 o superior para mejor rendimiento
- Configura un firewall adecuado
- Monitorea el uso de recursos del servidor
- Haz pruebas en entorno local antes de poner en producción

## 🎉 ¡A Configurar y Disfrutar!

<div align="center">
  <img src="https://i.imgur.com/6KjQx2L.jpg" alt="MuOnline Characters" width="600" style="border-radius: 10px;">
</div>

Este servidor de MuOnline Season 6 está listo para ser personalizado y configurado según tus necesidades. Ajusta los eventos, personaliza los drops, configura las rates y crea la experiencia perfecta para tus jugadores.

---

<div align="center">
  <img src="https://i.imgur.com/4KjQx2L.jpg" alt="MuOnline Logo" width="200" style="border-radius: 5px;">
  
  **Creado por 32BitsArg usando Louis Update 31 Files**  
  **Para la comunidad MuOnline Argentina** 🇦🇷
</div>
