/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.Processor;
import ghidra.app.util.datatype.microsoft.GUID;
import java.util.Objects;

public class PdbIdentifiers {
    private final int version;
    private final int signature;
    private final int age;
    private final GUID guid;
    private final Processor processor;

    public PdbIdentifiers(int version, int signature, int age, GUID guid, Processor processor) {
        this.version = version;
        this.signature = signature;
        this.age = age;
        this.guid = guid;
        this.processor = processor == null ? Processor.UNKNOWN : processor;
    }

    public int getVersion() {
        return this.version;
    }

    public int getSignature() {
        return this.signature;
    }

    public int getAge() {
        return this.age;
    }

    public GUID getGuid() {
        return this.guid;
    }

    public String toString() {
        return (this.guid != null ? this.guid.toString() : String.format("%08X", this.signature)) + ", " + this.age + ", " + this.version + ", " + String.valueOf((Object)this.processor);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.age, this.guid, this.processor, this.signature, this.version});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PdbIdentifiers other = (PdbIdentifiers)obj;
        return this.age == other.age && Objects.equals(this.guid, other.guid) && this.processor == other.processor && this.signature == other.signature && this.version == other.version;
    }
}

