/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.KeyEntryListener;
import docking.actions.KeyBindingUtils;
import docking.widgets.textfield.HintTextField;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Objects;
import javax.swing.KeyStroke;

public class KeyEntryTextField
extends HintTextField {
    private static final String HINT = "Type a key";
    private String disabledHint = "Type a key";
    private KeyEntryListener listener;
    private String ksName;
    private KeyStroke currentKeyStroke;

    public KeyEntryTextField(int columns, KeyEntryListener listener) {
        super(HINT);
        this.setName("Key Entry Text Field");
        this.getAccessibleContext().setAccessibleName(this.getName());
        this.setColumns(columns);
        this.listener = listener;
        this.addKeyListener(new MyKeyListener());
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.setHint(enabled ? HINT : this.disabledHint);
        super.setEnabled(enabled);
    }

    public void setDisabledHint(String disabledHint) {
        this.disabledHint = Objects.requireNonNull(disabledHint);
    }

    public KeyStroke getKeyStroke() {
        return this.currentKeyStroke;
    }

    public void setKeyStroke(KeyStroke ks) {
        this.processKeyStroke(ks, false);
        this.setText(KeyBindingUtils.parseKeyStroke(ks));
    }

    public void clearField() {
        this.ksName = null;
        this.setText("");
        this.currentKeyStroke = null;
    }

    public void clearKeyStroke() {
        if (this.currentKeyStroke == null) {
            return;
        }
        this.setText("");
        this.processKeyStroke(null, true);
    }

    private void processKeyStroke(KeyStroke ks, boolean notify) {
        char keyChar;
        this.ksName = null;
        this.currentKeyStroke = ks;
        if (ks != null && !Character.isWhitespace(keyChar = ks.getKeyChar()) && Character.getType(keyChar) != 15) {
            this.ksName = KeyBindingUtils.parseKeyStroke(ks);
        }
        if (notify) {
            this.listener.processEntry(ks);
        }
    }

    private class MyKeyListener
    implements KeyListener {
        private MyKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            e.consume();
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (KeyEntryTextField.this.ksName != null) {
                KeyEntryTextField.this.setText(KeyEntryTextField.this.ksName);
            } else {
                KeyEntryTextField.this.setText("");
            }
            e.consume();
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int keyCode = e.getKeyCode();
            KeyStroke keyStroke = null;
            if (!this.isModifiersOnly(e)) {
                keyStroke = KeyStroke.getKeyStroke(keyCode, e.getModifiersEx());
            }
            KeyEntryTextField.this.processKeyStroke(keyStroke, true);
            e.consume();
        }

        private boolean isModifiersOnly(KeyEvent event) {
            String keyText = KeyEvent.getKeyText(event.getKeyCode());
            return keyText.equals(KeyEvent.getKeyText(17)) || keyText.equals(KeyEvent.getKeyText(18)) || keyText.equals(KeyEvent.getKeyText(16)) || keyText.equals(KeyEvent.getKeyText(157));
        }
    }
}

