/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.util;

import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;

public class VTFunctionSizeUtil {
    private VTFunctionSizeUtil() {
    }

    public static AddressSetView minimumSizeFunctionFilter(Program program, AddressSetView originalAddressSet, int minimumFunctionSize, TaskMonitor monitor) {
        AddressSet result = new AddressSet(originalAddressSet);
        FunctionIterator ii = program.getFunctionManager().getFunctions(originalAddressSet, true);
        while (ii.hasNext() && !monitor.isCancelled()) {
            Function function = (Function)ii.next();
            AddressSetView body = function.getBody();
            if (!function.isThunk() && body.getNumAddresses() >= (long)minimumFunctionSize) continue;
            AddressRangeIterator addressRanges = body.getAddressRanges();
            for (AddressRange addressRange : addressRanges) {
                result.delete(addressRange);
            }
        }
        return result;
    }
}

