/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.threadcommand;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ExceptionStateX86_64
implements StructConverter {
    public int trapno;
    public int err;
    public long faultvaddr;

    ExceptionStateX86_64(BinaryReader reader) throws IOException {
        this.trapno = reader.readNextInt();
        this.err = reader.readNextInt();
        this.faultvaddr = reader.readNextLong();
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("x86_exception_state64", 0);
        struct.add(DWORD, "trapno", null);
        struct.add(DWORD, "err", null);
        struct.add(QWORD, "faultvaddr", null);
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

