/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.exceptionhandlers.gcc;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.LEB128Info;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import java.io.IOException;

public class GccAnalysisUtils {
    public static byte readByte(Program program, Address addr) throws MemoryAccessException {
        return program.getMemory().getByte(addr);
    }

    public static int readWord(Program program, Address addr) throws MemoryAccessException {
        return program.getMemory().getShort(addr);
    }

    public static long readDWord(Program program, Address addr) throws MemoryAccessException {
        return program.getMemory().getInt(addr);
    }

    public static long readQWord(Program program, Address addr) throws MemoryAccessException {
        return program.getMemory().getLong(addr);
    }

    public static void readBytes(Program program, Address addr, byte[] buffer) throws MemoryAccessException {
        program.getMemory().getBytes(addr, buffer);
    }

    public static LEB128Info readULEB128Info(Program program, Address addr) throws MemoryAccessException {
        LEB128Info uleb128 = GccAnalysisUtils.readLEB128Info(program, addr, false);
        return uleb128;
    }

    public static LEB128Info readSLEB128Info(Program program, Address addr) throws MemoryAccessException {
        LEB128Info sleb128 = GccAnalysisUtils.readLEB128Info(program, addr, true);
        return sleb128;
    }

    private static LEB128Info readLEB128Info(Program program, Address addr, boolean isSigned) throws MemoryAccessException {
        MemoryByteProvider mbp = new MemoryByteProvider(program.getMemory(), addr.getAddressSpace());
        try {
            BinaryReader br = new BinaryReader(mbp, !program.getMemory().isBigEndian());
            br.setPointerIndex(addr.getOffset());
            LEB128Info lEB128Info = LEB128Info.readValue(br, isSigned);
            mbp.close();
            return lEB128Info;
        }
        catch (Throwable throwable) {
            try {
                try {
                    mbp.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new MemoryAccessException("Error reading LEB128 value at " + addr.toString(), (Throwable)e);
            }
        }
    }
}

