/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation.locationreferences;

import ghidra.app.plugin.core.navigation.locationreferences.DataTypeLocationDescriptor;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Program;
import ghidra.program.util.FunctionParameterFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.exception.AssertException;

public class FunctionParameterTypeLocationDescriptor
extends DataTypeLocationDescriptor {
    FunctionParameterTypeLocationDescriptor(ProgramLocation location, Program program) {
        super(location, program);
        if (!(location instanceof FunctionParameterFieldLocation)) {
            throw new AssertException("Unexpected ProgramLocation type - Cannot create a LocationDescriptor for type: " + String.valueOf(location));
        }
    }

    @Override
    protected String generateLabel() {
        return this.getDataTypeName();
    }

    @Override
    protected String getDataTypeName() {
        FunctionParameterFieldLocation parameterLocation = (FunctionParameterFieldLocation)this.getLocation();
        return parameterLocation.getParameter().getDataType().getDisplayName();
    }

    @Override
    protected DataType getSourceDataType() {
        return ((FunctionParameterFieldLocation)this.getLocation()).getParameter().getDataType();
    }
}

