/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.wizard.project;

import docking.wizard.WizardModel;
import docking.wizard.WizardStep;
import ghidra.framework.client.RepositoryServerAdapter;
import ghidra.framework.main.ProjectAccessPanel;
import ghidra.framework.main.wizard.project.ProjectWizardData;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.remote.User;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JComponent;

public class ProjectAccessStep
extends WizardStep<ProjectWizardData> {
    private ProjectAccessPanel panel;
    private PluginTool tool;

    public ProjectAccessStep(WizardModel<ProjectWizardData> model, PluginTool tool) {
        super(model, "", new HelpLocation("FrontEndPlugin", "UserAccessList"));
        this.tool = tool;
    }

    public void initialize(ProjectWizardData data) {
        this.setTitle("Specify Users for Repository: " + data.getRepositoryName());
        String repositoryName = data.getRepositoryName();
        RepositoryServerAdapter server = data.getServer();
        try {
            String[] allUsers = server.getAllUsers();
            ArrayList<User> userList = new ArrayList<User>();
            userList.add(new User(server.getUser(), 2));
            this.panel = new ProjectAccessPanel(allUsers, server.getUser(), userList, repositoryName, server.anonymousAccessAllowed(), false, this.tool);
        }
        catch (IOException e) {
            Msg.error((Object)((Object)this), (Object)"Error creating project access panel");
        }
    }

    public boolean isApplicable(ProjectWizardData data) {
        return data.isSharedProject() && data.isNewRepository();
    }

    public boolean isValid() {
        return this.panel != null;
    }

    public void populateData(ProjectWizardData data) {
        User[] projectUsers = this.panel.getProjectUsers();
        boolean allowAnonymousAccess = this.panel.allowAnonymousAccess();
        data.setProjectUsers(projectUsers);
        data.setAllowAnonymousAccess(allowAnonymousAccess);
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public boolean apply(ProjectWizardData data) {
        return true;
    }

    public boolean canFinish(ProjectWizardData data) {
        return this.panel != null;
    }
}

