/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler;

import ghidra.app.plugin.assembler.Assembler;
import ghidra.app.plugin.assembler.AssemblySemanticException;
import ghidra.app.plugin.assembler.AssemblySyntaxException;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyPatternBlock;
import ghidra.program.model.address.Address;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class AssemblyBuffer {
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private final Assembler asm;
    private final Address entry;

    public AssemblyBuffer(Assembler asm, Address entry) {
        this.asm = asm;
        this.entry = entry;
    }

    public Address getNext() {
        return this.entry.add(this.baos.size());
    }

    public byte[] assemble(String line, AssemblyPatternBlock ctx) throws AssemblySyntaxException, AssemblySemanticException, IOException {
        return this.emit(this.asm.assembleLine(this.getNext(), line, ctx));
    }

    public byte[] assemble(String line) throws AssemblySyntaxException, AssemblySemanticException, IOException {
        return this.emit(this.asm.assembleLine(this.getNext(), line));
    }

    public byte[] assemble(Address at, String line, AssemblyPatternBlock ctx) throws AssemblySyntaxException, AssemblySemanticException, IOException {
        byte[] full = this.baos.toByteArray();
        byte[] bytes = this.asm.assembleLine(at, line, ctx);
        System.arraycopy(bytes, 0, full, (int)at.subtract(this.entry), bytes.length);
        this.baos.reset();
        this.baos.write(full);
        return bytes;
    }

    public byte[] assemble(Address at, String line) throws AssemblySyntaxException, AssemblySemanticException, IOException {
        byte[] full = this.baos.toByteArray();
        byte[] bytes = this.asm.assembleLine(at, line);
        System.arraycopy(bytes, 0, full, (int)at.subtract(this.entry), bytes.length);
        this.baos.reset();
        this.baos.write(full);
        return bytes;
    }

    public byte[] emit(byte[] bytes) throws IOException {
        this.baos.write(bytes);
        return bytes;
    }

    public byte[] getBytes() {
        return this.baos.toByteArray();
    }

    public Address getEntry() {
        return this.entry;
    }

    public Assembler getAssembler() {
        return this.asm;
    }
}

