/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.featurette;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.Tool;
import docking.WindowPosition;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import generic.theme.GIcon;
import ghidra.framework.options.SaveState;
import ghidra.graph.VisualGraph;
import ghidra.graph.VisualGraphComponentProvider;
import ghidra.graph.featurette.VisualGraphFeaturette;
import ghidra.graph.viewer.GraphComponent;
import ghidra.graph.viewer.GraphSatelliteListener;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualGraphView;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.actions.VgSatelliteContext;
import ghidra.graph.viewer.actions.VisualGraphActionContext;
import ghidra.util.HelpLocation;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;

public class VgSatelliteFeaturette<V extends VisualVertex, E extends VisualEdge<V>, G extends VisualGraph<V, E>>
implements VisualGraphFeaturette<V, E, G> {
    private static final Icon ICON = new GIcon("icon.graph.satellite");
    private static final String DISPLAY_SATELLITE = "DISPLAY_SATELLITE";
    private static final String DOCK_SATELLITE = "DOCK_SATELLITE";
    private static final String DOCK_SATELLITE_POSITION = "DOCK_SATELLITE_POSITION";
    private ToggleDockingAction toggleSatelliteAction;
    private ToggleDockingAction dockSatelliteAction;
    private ToggleDockingAction upperLeftAction;
    private ToggleDockingAction upperRightAction;
    private ToggleDockingAction lowerLeftAction;
    private ToggleDockingAction lowerRightAction;
    private Tool tool;
    private VisualGraphView<?, ?, ?> view;
    private String owner;
    private String providerName;
    private String windowGroup;
    private boolean closedByPrimaryProvider;
    private VgUndockedSatelliteProvider satelliteProvider;

    @Override
    public void writeConfigState(SaveState saveState) {
        saveState.putBoolean(DOCK_SATELLITE, this.dockSatelliteAction.isSelected());
        saveState.putBoolean(DISPLAY_SATELLITE, this.toggleSatelliteAction.isSelected());
        saveState.putString(DOCK_SATELLITE_POSITION, this.view.getSatellitePosition().toString());
    }

    @Override
    public void readConfigState(SaveState saveState) {
        boolean dockSatellite = saveState.getBoolean(DOCK_SATELLITE, true);
        this.dockSatelliteAction.setSelected(dockSatellite);
        this.view.setSatelliteDocked(dockSatellite);
        boolean showSatellite = saveState.getBoolean(DISPLAY_SATELLITE, true);
        this.toggleSatelliteAction.setSelected(showSatellite);
        this.view.setSatelliteVisible(showSatellite);
        String positionString = saveState.getString(DOCK_SATELLITE_POSITION, GraphComponent.SatellitePosition.LOWER_RIGHT.name());
        GraphComponent.SatellitePosition position = GraphComponent.SatellitePosition.valueOf(positionString);
        this.view.setSatellitePosition(position);
        this.deselectAllSatellitePositions();
        switch (position) {
            case LOWER_LEFT: {
                this.lowerLeftAction.setSelected(true);
                break;
            }
            case LOWER_RIGHT: {
                this.lowerRightAction.setSelected(true);
                break;
            }
            case UPPER_LEFT: {
                this.upperLeftAction.setSelected(true);
                break;
            }
            case UPPER_RIGHT: {
                this.upperRightAction.setSelected(true);
            }
        }
    }

    @Override
    public void init(VisualGraphComponentProvider<V, E, G> provider) {
        this.tool = provider.getTool();
        this.view = provider.getView();
        this.owner = provider.getOwner();
        this.providerName = provider.getName();
        this.windowGroup = provider.getWindowGroup();
        this.view.setSatelliteListener(new SatelliteListener());
        this.addActions(provider);
    }

    @Override
    public void providerOpened(VisualGraphComponentProvider<V, E, G> provider) {
        if (this.satelliteProvider != null) {
            this.satelliteProvider.setVisible(true);
            this.view.setSatelliteVisible(true);
        }
    }

    @Override
    public void providerClosed(VisualGraphComponentProvider<V, E, G> provider) {
        if (this.satelliteProvider != null) {
            this.closedByPrimaryProvider = true;
            this.satelliteProvider.closeComponent();
            this.closedByPrimaryProvider = false;
        }
    }

    public ComponentProvider getSatelliteProvider() {
        return this.satelliteProvider;
    }

    private void addActions(final ComponentProvider provider) {
        this.toggleSatelliteAction = new ToggleDockingAction("Display Satellite View", this.owner){

            public void actionPerformed(ActionContext context) {
                VgSatelliteFeaturette.this.view.setSatelliteVisible(this.isSelected());
            }

            public boolean isAddToPopup(ActionContext context) {
                ComponentProvider componentProvider = context.getComponentProvider();
                if (componentProvider != provider && componentProvider != VgSatelliteFeaturette.this.satelliteProvider) {
                    return false;
                }
                if (!(context instanceof VisualGraphActionContext)) {
                    return false;
                }
                VisualGraphActionContext vgContext = (VisualGraphActionContext)context;
                return vgContext.shouldShowSatelliteActions();
            }
        };
        this.toggleSatelliteAction.setSelected(true);
        this.toggleSatelliteAction.setPopupMenuData(new MenuData(new String[]{"Display Satellite View"}));
        this.toggleSatelliteAction.setHelpLocation(new HelpLocation("FunctionCallGraphPlugin", "Satellite_View"));
        this.dockSatelliteAction = new ToggleDockingAction("Dock Satellite View", this.owner){

            public void actionPerformed(ActionContext context) {
                VgSatelliteFeaturette.this.view.setSatelliteDocked(this.isSelected());
            }

            public boolean isAddToPopup(ActionContext context) {
                ComponentProvider componentProvider = context.getComponentProvider();
                if (componentProvider != provider && componentProvider != VgSatelliteFeaturette.this.satelliteProvider) {
                    return false;
                }
                if (!(context instanceof VisualGraphActionContext)) {
                    return false;
                }
                VisualGraphActionContext vgContext = (VisualGraphActionContext)context;
                return vgContext.shouldShowSatelliteActions();
            }
        };
        this.dockSatelliteAction.setSelected(true);
        this.dockSatelliteAction.setPopupMenuData(new MenuData(new String[]{"Dock Satellite View"}));
        this.dockSatelliteAction.setHelpLocation(new HelpLocation("FunctionCallGraphPlugin", "Satellite_View"));
        this.upperLeftAction = new SatellitePositionAction("Upper Left", GraphComponent.SatellitePosition.UPPER_LEFT, provider);
        this.upperRightAction = new SatellitePositionAction("Upper Right", GraphComponent.SatellitePosition.UPPER_RIGHT, provider);
        this.lowerLeftAction = new SatellitePositionAction("Lower Left", GraphComponent.SatellitePosition.LOWER_LEFT, provider);
        this.lowerRightAction = new SatellitePositionAction("Lower Right", GraphComponent.SatellitePosition.LOWER_RIGHT, provider);
        this.lowerRightAction.setSelected(true);
        this.tool.addAction((DockingActionIf)this.toggleSatelliteAction);
        this.tool.addAction((DockingActionIf)this.dockSatelliteAction);
        this.tool.addAction((DockingActionIf)this.upperLeftAction);
        this.tool.addAction((DockingActionIf)this.upperRightAction);
        this.tool.addAction((DockingActionIf)this.lowerLeftAction);
        this.tool.addAction((DockingActionIf)this.lowerRightAction);
    }

    @Override
    public void remove() {
        if (this.satelliteProvider != null) {
            this.satelliteProvider.removeFromTool();
        }
    }

    public void deselectAllSatellitePositions() {
        this.upperLeftAction.setSelected(false);
        this.upperRightAction.setSelected(false);
        this.lowerLeftAction.setSelected(false);
        this.lowerRightAction.setSelected(false);
    }

    private void closeSatelliteProvider(boolean remove) {
        if (this.satelliteProvider == null) {
            return;
        }
        if (remove) {
            this.satelliteProvider.removeFromTool();
            this.satelliteProvider = null;
        } else {
            this.satelliteProvider.closeComponent();
        }
    }

    private void showSatelliteProvider() {
        if (this.satelliteProvider == null) {
            JComponent component = this.view.getUndockedSatelliteComponent();
            this.satelliteProvider = new VgUndockedSatelliteProvider(this.tool, component, this.providerName + " Satellite", this.owner, this.windowGroup);
            this.satelliteProvider.setVisible(true);
        } else {
            this.satelliteProvider.toFront();
        }
    }

    private class SatelliteListener
    implements GraphSatelliteListener {
        private SatelliteListener() {
        }

        @Override
        public void satelliteVisibilityChanged(boolean docked, boolean visible) {
            VgSatelliteFeaturette.this.toggleSatelliteAction.setSelected(visible);
            VgSatelliteFeaturette.this.dockSatelliteAction.setSelected(docked);
            if (docked) {
                VgSatelliteFeaturette.this.closeSatelliteProvider(true);
                return;
            }
            if (!visible) {
                VgSatelliteFeaturette.this.closeSatelliteProvider(false);
            } else {
                VgSatelliteFeaturette.this.showSatelliteProvider();
            }
        }
    }

    private class VgUndockedSatelliteProvider
    extends ComponentProvider {
        private JComponent satelliteComponent;

        public VgUndockedSatelliteProvider(Tool tool, JComponent component, String name, String owner, String windowGroup) {
            super(tool, name, owner);
            this.satelliteComponent = component;
            this.satelliteComponent.setMinimumSize(new Dimension(400, 400));
            this.setWindowMenuGroup(windowGroup);
            this.setIcon(ICON);
            this.setDefaultWindowPosition(WindowPosition.WINDOW);
            this.addToTool();
        }

        public JComponent getComponent() {
            return this.satelliteComponent;
        }

        public ActionContext getActionContext(MouseEvent event) {
            return new VgSatelliteContext(this);
        }

        public void componentHidden() {
            if (!VgSatelliteFeaturette.this.dockSatelliteAction.isSelected()) {
                VgSatelliteFeaturette.this.view.setSatelliteVisible(false);
            }
            if (!VgSatelliteFeaturette.this.closedByPrimaryProvider) {
                VgSatelliteFeaturette.this.satelliteProvider.removeFromTool();
                VgSatelliteFeaturette.this.satelliteProvider = null;
            }
        }
    }

    private class SatellitePositionAction
    extends ToggleDockingAction {
        private GraphComponent.SatellitePosition position;
        private ComponentProvider provider;

        public SatellitePositionAction(String name, GraphComponent.SatellitePosition posiiton, ComponentProvider provider) {
            super(name, VgSatelliteFeaturette.this.owner);
            this.position = posiiton;
            this.provider = provider;
            this.setPopupMenuData(new MenuData(new String[]{"Docked Satellite Position", name}));
            this.setHelpLocation(new HelpLocation("FunctionCallGraphPlugin", "Satellite_Location"));
        }

        public void actionPerformed(ActionContext context) {
            VgSatelliteFeaturette.this.deselectAllSatellitePositions();
            this.setSelected(true);
            VgSatelliteFeaturette.this.view.setSatellitePosition(this.position);
        }

        public boolean isAddToPopup(ActionContext context) {
            ComponentProvider componentProvider = context.getComponentProvider();
            if (componentProvider != this.provider && componentProvider != VgSatelliteFeaturette.this.satelliteProvider) {
                return false;
            }
            if (context instanceof VisualGraphActionContext) {
                VisualGraphActionContext vgContext = (VisualGraphActionContext)context;
                return vgContext.shouldShowSatelliteActions();
            }
            return false;
        }
    }
}

