/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.tracermi.launcher;

import generic.theme.GIcon;
import generic.theme.Gui;
import ghidra.debug.api.ValStr;
import ghidra.debug.api.tracermi.LaunchParameter;
import ghidra.framework.Application;
import ghidra.framework.plugintool.AutoConfigState;
import ghidra.pty.ShellUtils;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;

public abstract class ScriptAttributesParser {
    public static final String ENV_GHIDRA_HOME = "GHIDRA_HOME";
    public static final String ENV_GHIDRA_TRACE_RMI_ADDR = "GHIDRA_TRACE_RMI_ADDR";
    public static final String ENV_GHIDRA_TRACE_RMI_HOST = "GHIDRA_TRACE_RMI_HOST";
    public static final String ENV_GHIDRA_TRACE_RMI_PORT = "GHIDRA_TRACE_RMI_PORT";
    public static final String AT_ARG = "@arg";
    public static final String AT_ARGS = "@args";
    public static final String AT_DESC = "@desc";
    public static final String AT_ENUM = "@enum";
    public static final String AT_ENV = "@env";
    public static final String AT_HELP = "@help";
    public static final String AT_ICON = "@icon";
    public static final String AT_IMAGE_OPT = "@image-opt";
    public static final String AT_MENU_GROUP = "@menu-group";
    public static final String AT_MENU_ORDER = "@menu-order";
    public static final String AT_MENU_PATH = "@menu-path";
    public static final String AT_TITLE = "@title";
    public static final String AT_TIMEOUT = "@timeout";
    public static final String AT_TTY = "@tty";
    public static final String KEY_ARGS = "args";
    public static final String PREFIX_ARG = "arg:";
    public static final String PREFIX_ENV = "env:";
    public static final String MSGPAT_DUPLICATE_TAG = "%s: Duplicate %s";
    public static final String MSGPAT_INVALID_ARG_SYNTAX = "%s: Invalid %s syntax. Use :type \"Display\" \"Tool Tip\"";
    public static final String MSGPAT_INVALID_ARGS_SYNTAX = "%s: Invalid %s syntax. Use \"Display\" \"Tool Tip\"";
    public static final String MSGPAT_INVALID_ENUM_SYNTAX = "%s: Invalid %s syntax. Use NAME:type Choice1 [ChoiceN...]";
    public static final String MSGPAT_INVALID_ENV_SYNTAX = "%s: Invalid %s syntax. Use NAME:type=default \"Display\" \"Tool Tip\"";
    public static final String MSGPAT_INVALID_HELP_SYNTAX = "%s: Invalid %s syntax. Use Topic#anchor";
    public static final String MSGPAT_INVALID_TIMEOUT_SYNTAX = "%s: Invalid %s syntax. Use [milliseconds]";
    public static final String MSGPAT_INVALID_TTY_BAD_VAL = "%s: In %s: Parameter '%s' has type %s, but '%s' cannot be parsed as such";
    public static final String MSGPAT_INVALID_TTY_NO_PARAM = "%s: In %s: No such parameter '%s'";
    public static final String MSGPAT_INVALID_TTY_NOT_BOOL = "%s: In %s: Parameter '%s' must have bool type";
    public static final String MSGPAT_INVALID_TTY_SYNTAX = "%s: Invalid %s syntax. Use TTY_TARGET [if env:OPT [== VAL]]";
    private int argc;
    private String title;
    private StringBuilder description;
    private String iconId;
    private HelpLocation helpLocation;
    private String menuGroup;
    private String menuOrder;
    private List<String> menuPath;
    private final Map<String, UserType<?>> userTypes = new HashMap();
    private final Map<String, LaunchParameter<?>> parameters = new LinkedHashMap();
    private final Map<String, TtyCondition> extraTtys = new LinkedHashMap<String, TtyCondition>();
    private int timeoutMillis = 10000;
    private String imageOptKey;

    protected static String addrToString(InetAddress address) {
        if (address.isAnyLocalAddress()) {
            return "127.0.0.1";
        }
        return address.getHostAddress();
    }

    protected static String sockToString(SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            InetSocketAddress tcp = (InetSocketAddress)address;
            return ScriptAttributesParser.addrToString(tcp.getAddress()) + ":" + tcp.getPort();
        }
        throw new AssertionError((Object)("Unhandled address type " + String.valueOf(address)));
    }

    public static void processArguments(List<String> commandLine, Map<String, String> env, File script, Map<String, LaunchParameter<?>> parameters, Map<String, ValStr<?>> args, SocketAddress address) {
        LaunchParameter<?> param;
        commandLine.add(script.getAbsolutePath());
        env.put(ENV_GHIDRA_HOME, Application.getInstallationDirectory().getAbsolutePath());
        if (address != null) {
            env.put(ENV_GHIDRA_TRACE_RMI_ADDR, ScriptAttributesParser.sockToString(address));
            if (address instanceof InetSocketAddress) {
                InetSocketAddress tcp = (InetSocketAddress)address;
                env.put(ENV_GHIDRA_TRACE_RMI_HOST, tcp.getAddress().getHostAddress());
                env.put(ENV_GHIDRA_TRACE_RMI_PORT, Integer.toString(tcp.getPort()));
            }
        }
        int i = 1;
        while ((param = parameters.get(PREFIX_ARG + i)) != null) {
            commandLine.add(param.get(args).normStr());
            ++i;
        }
        param = parameters.get(KEY_ARGS);
        if (param != null) {
            commandLine.addAll(ShellUtils.parseArgs((String)param.get(args).str()));
        }
        for (Map.Entry<String, LaunchParameter<?>> ent : parameters.entrySet()) {
            String key = ent.getKey();
            if (!key.startsWith(PREFIX_ENV)) continue;
            String varName = key.substring(PREFIX_ENV.length());
            ValStr val = ent.getValue().get(args);
            env.put(varName, ValStr.normStr((ValStr)val));
        }
    }

    protected abstract boolean ignoreLine(int var1, String var2);

    protected abstract String removeDelimiter(String var1);

    public ScriptAttributes parseStream(InputStream stream, String scriptName) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
            String line;
            int lineNo = 1;
            while ((line = reader.readLine()) != null) {
                if (!this.ignoreLine(lineNo, line)) {
                    String comment = this.removeDelimiter(line);
                    if (comment == null) break;
                    this.parseComment(new Location(scriptName, lineNo), comment);
                }
                ++lineNo;
            }
            ScriptAttributes scriptAttributes = this.validate(scriptName);
            return scriptAttributes;
        }
    }

    public ScriptAttributes parseFile(File script) throws FileNotFoundException {
        try {
            return this.parseStream(new FileInputStream(script), script.getName());
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void parseComment(Location loc, String comment) {
        if (comment.isBlank()) {
            return;
        }
        String[] parts = comment.split("\\s+", 2);
        if (!parts[0].startsWith("@")) {
            return;
        }
        if (parts.length == 1) {
            this.parseUnrecognized(loc, comment);
        } else {
            switch (parts[0].trim()) {
                case "@arg": {
                    this.parseArg(loc, parts[1], ++this.argc);
                    break;
                }
                case "@args": {
                    this.parseArgs(loc, parts[1]);
                    break;
                }
                case "@desc": {
                    this.parseDesc(loc, parts[1]);
                    break;
                }
                case "@enum": {
                    this.parseEnum(loc, parts[1]);
                    break;
                }
                case "@env": {
                    this.parseEnv(loc, parts[1]);
                    break;
                }
                case "@help": {
                    this.parseHelp(loc, parts[1]);
                    break;
                }
                case "@icon": {
                    this.parseIcon(loc, parts[1]);
                    break;
                }
                case "@image-opt": {
                    this.parseImageOpt(loc, parts[1]);
                    break;
                }
                case "@menu-group": {
                    this.parseMenuGroup(loc, parts[1]);
                    break;
                }
                case "@menu-order": {
                    this.parseMenuOrder(loc, parts[1]);
                    break;
                }
                case "@menu-path": {
                    this.parseMenuPath(loc, parts[1]);
                    break;
                }
                case "@timeout": {
                    this.parseTimeout(loc, parts[1]);
                    break;
                }
                case "@title": {
                    this.parseTitle(loc, parts[1]);
                    break;
                }
                case "@tty": {
                    this.parseTty(loc, parts[1]);
                    break;
                }
                default: {
                    this.parseUnrecognized(loc, comment);
                }
            }
        }
    }

    protected void parseArg(Location loc, String str, int argNum) {
        List parts = ShellUtils.parseArgs((String)str);
        if (parts.size() != 3) {
            this.reportError(MSGPAT_INVALID_ARG_SYNTAX.formatted(loc, AT_ARG));
            return;
        }
        String colonType = ((String)parts.get(0)).trim();
        if (!colonType.startsWith(":")) {
            this.reportError(MSGPAT_INVALID_ARG_SYNTAX.formatted(loc, AT_ARG));
            return;
        }
        boolean required = colonType.endsWith("!");
        int endType = required ? colonType.length() - 1 : colonType.length();
        try {
            OptType<?> type = OptType.parse(loc, colonType.substring(1, endType), this.userTypes);
            String name = PREFIX_ARG + argNum;
            this.parameters.put(name, type.createParameter(name, (String)parts.get(1), (String)parts.get(2), required, new ValStr(null, "")));
        }
        catch (ParseException e) {
            this.reportError(e.getMessage());
        }
    }

    protected void parseArgs(Location loc, String str) {
        List parts = ShellUtils.parseArgs((String)str);
        if (parts.size() != 2) {
            this.reportError(MSGPAT_INVALID_ARGS_SYNTAX.formatted(loc, AT_ARGS));
            return;
        }
        LaunchParameter<String> parameter = BaseType.STRING.createParameter(KEY_ARGS, (String)parts.get(0), (String)parts.get(1), false, (ValStr<String>)ValStr.str((String)""));
        if (this.parameters.put(KEY_ARGS, parameter) != null) {
            this.reportWarning("%s: Duplicate %s. Replaced".formatted(loc, AT_ARGS));
        }
    }

    protected void parseDesc(Location loc, String str) {
        if (this.description == null) {
            this.description = new StringBuilder();
        }
        this.description.append(str);
        this.description.append("\n");
    }

    protected <T> UserType<T> parseEnumChoices(Location loc, BaseType<T> baseType, List<String> choiceParts) {
        ArrayList choices = new ArrayList();
        boolean err = false;
        for (String s : choiceParts) {
            try {
                choices.add(baseType.decode(loc, s));
            }
            catch (ParseException e) {
                this.reportError(e.getMessage());
            }
        }
        if (err) {
            return null;
        }
        return baseType.withChoices(choices);
    }

    protected void parseEnum(Location loc, String str) {
        BaseType<?> baseType;
        List parts = ShellUtils.parseArgs((String)str);
        if (parts.size() < 2) {
            this.reportError(MSGPAT_INVALID_ENUM_SYNTAX.formatted(loc, AT_ENUM));
            return;
        }
        String[] nameParts = ((String)parts.get(0)).split(":", 2);
        if (nameParts.length != 2) {
            this.reportError(MSGPAT_INVALID_ENUM_SYNTAX.formatted(loc, AT_ENUM));
            return;
        }
        String name = nameParts[0].trim();
        try {
            baseType = BaseType.parse(loc, nameParts[1]);
        }
        catch (ParseException e) {
            this.reportError(e.getMessage());
            return;
        }
        UserType<?> userType = this.parseEnumChoices(loc, baseType, parts.subList(1, parts.size()));
        if (userType == null) {
            return;
        }
        if (this.userTypes.put(name, userType) != null) {
            this.reportWarning("%s: Duplicate %s %s. Replaced.".formatted(loc, AT_ENUM, name));
        }
    }

    protected void parseEnv(Location loc, String str) {
        List parts = ShellUtils.parseArgs((String)str);
        if (parts.size() != 3) {
            this.reportError(MSGPAT_INVALID_ENV_SYNTAX.formatted(loc, AT_ENV));
            return;
        }
        String[] nameParts = ((String)parts.get(0)).split(":", 2);
        if (nameParts.length != 2) {
            this.reportError(MSGPAT_INVALID_ENV_SYNTAX.formatted(loc, AT_ENV));
            return;
        }
        String trimmed = nameParts[0].trim();
        String name = PREFIX_ENV + trimmed;
        String[] tadParts = nameParts[1].split("=", 2);
        if (tadParts.length != 2) {
            this.reportError(MSGPAT_INVALID_ENV_SYNTAX.formatted(loc, AT_ENV));
            return;
        }
        String typePart = tadParts[0].trim();
        boolean required = typePart.endsWith("!");
        int endType = required ? typePart.length() - 1 : typePart.length();
        try {
            TypeAndDefault<?> tad = TypeAndDefault.parse(loc, typePart.substring(0, endType), tadParts[1].trim(), this.userTypes);
            LaunchParameter<?> param = tad.createParameter(name, (String)parts.get(1), (String)parts.get(2), required);
            if (this.parameters.put(name, param) != null) {
                this.reportWarning("%s: Duplicate %s %s. Replaced.".formatted(loc, AT_ENV, trimmed));
            }
        }
        catch (ParseException e) {
            this.reportError(e.getMessage());
        }
    }

    protected void parseHelp(Location loc, String str) {
        String[] parts;
        if (this.helpLocation != null) {
            this.reportWarning(MSGPAT_DUPLICATE_TAG.formatted(loc, AT_HELP));
        }
        if ((parts = str.trim().split("#", 2)).length != 2) {
            this.reportError(MSGPAT_INVALID_HELP_SYNTAX.formatted(loc, AT_HELP));
            return;
        }
        this.helpLocation = new HelpLocation(parts[0].trim(), parts[1].trim());
    }

    protected void parseIcon(Location loc, String str) {
        if (this.iconId != null) {
            this.reportWarning(MSGPAT_DUPLICATE_TAG.formatted(loc, AT_ICON));
        }
        this.iconId = str.trim();
        if (!Gui.hasIcon((String)this.iconId)) {
            this.reportError("%s: Icon id %s not registered in the theme".formatted(loc, this.iconId));
        }
    }

    protected void parseImageOpt(Location loc, String str) {
        if (this.imageOptKey != null) {
            this.reportWarning(MSGPAT_DUPLICATE_TAG.formatted(loc, AT_IMAGE_OPT));
        }
        this.imageOptKey = str.strip();
    }

    protected void parseMenuGroup(Location loc, String str) {
        if (this.menuGroup != null) {
            this.reportWarning(MSGPAT_DUPLICATE_TAG.formatted(loc, AT_MENU_GROUP));
        }
        this.menuGroup = str;
    }

    protected void parseMenuOrder(Location loc, String str) {
        if (this.menuOrder != null) {
            this.reportWarning(MSGPAT_DUPLICATE_TAG.formatted(loc, AT_MENU_ORDER));
        }
        this.menuOrder = str;
    }

    protected void parseMenuPath(Location loc, String str) {
        if (this.menuPath != null) {
            this.reportWarning(MSGPAT_DUPLICATE_TAG.formatted(loc, AT_MENU_PATH));
        }
        this.menuPath = List.of(str.trim().split("\\."));
        if (this.menuPath.isEmpty()) {
            this.reportError("%s: Empty %s. Ignoring.".formatted(loc, AT_MENU_PATH));
        }
    }

    protected void parseTimeout(Location loc, String str) {
        try {
            this.timeoutMillis = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            this.reportError(MSGPAT_INVALID_TIMEOUT_SYNTAX.formatted(loc, AT_TIMEOUT));
        }
    }

    protected void parseTitle(Location loc, String str) {
        if (this.title != null) {
            this.reportWarning(MSGPAT_DUPLICATE_TAG.formatted(loc, AT_TITLE));
        }
        this.title = str;
    }

    protected void putTty(Location loc, String name, TtyCondition condition) {
        if (this.extraTtys.put(name, condition) != null) {
            this.reportWarning("%s: Duplicate %s. Ignored".formatted(loc, AT_TTY));
        }
    }

    protected void parseTty(Location loc, String str) {
        List parts = ShellUtils.parseArgs((String)str);
        switch (parts.size()) {
            case 1: {
                this.putTty(loc, (String)parts.get(0), ConstTtyCondition.ALWAYS);
                return;
            }
            case 3: {
                if (!"if".equals(parts.get(1))) break;
                LaunchParameter<?> param = this.parameters.get(parts.get(2));
                if (param == null) {
                    this.reportError(MSGPAT_INVALID_TTY_NO_PARAM.formatted(loc, AT_TTY, parts.get(2)));
                    return;
                }
                if (param.type() != Boolean.class) {
                    this.reportError(MSGPAT_INVALID_TTY_NOT_BOOL.formatted(loc, AT_TTY, param.name()));
                    return;
                }
                LaunchParameter<?> asBoolParam = param;
                this.putTty(loc, (String)parts.get(0), new BoolTtyCondition(asBoolParam));
                return;
            }
            case 5: {
                if (!"if".equals(parts.get(1)) || !"==".equals(parts.get(3))) break;
                LaunchParameter<?> param = this.parameters.get(parts.get(2));
                if (param == null) {
                    this.reportError(MSGPAT_INVALID_TTY_NO_PARAM.formatted(loc, AT_TTY, parts.get(2)));
                    return;
                }
                try {
                    Object value = param.decode((String)parts.get(4)).val();
                    this.putTty(loc, (String)parts.get(0), new EqualsTtyCondition(param, value));
                    return;
                }
                catch (Exception e) {
                    this.reportError(MSGPAT_INVALID_TTY_BAD_VAL.formatted(loc, AT_TTY, param.name(), param.type(), parts.get(4)));
                    return;
                }
            }
        }
        this.reportError(MSGPAT_INVALID_TTY_SYNTAX.formatted(loc, AT_TTY));
    }

    protected void parseUnrecognized(Location loc, String line) {
        this.reportWarning("%s: Unrecognized metadata: %s".formatted(loc, line));
    }

    protected ScriptAttributes validate(String fileName) {
        if (this.title == null) {
            this.reportError("%s is required. Using script file name: '%s'".formatted(AT_TITLE, fileName));
            this.title = fileName;
        }
        if (this.menuPath == null) {
            this.menuPath = List.of(this.title);
        }
        if (this.menuGroup == null) {
            this.menuGroup = "";
        }
        if (this.menuOrder == null) {
            this.menuOrder = "";
        }
        if (this.iconId == null) {
            this.iconId = "icon.debugger";
        }
        LaunchParameter<?> imageOpt = null;
        if (this.imageOptKey != null && (imageOpt = this.parameters.get(this.imageOptKey)) == null) {
            this.reportError("%s: %s refers to %s, which is not a parameter name".formatted(fileName, AT_IMAGE_OPT, this.imageOptKey));
        }
        return new ScriptAttributes(this.title, this.getDescription(), List.copyOf(this.menuPath), this.menuGroup, this.menuOrder, (Icon)new GIcon(this.iconId), this.helpLocation, Collections.unmodifiableMap(new LinkedHashMap(this.parameters)), Collections.unmodifiableMap(new LinkedHashMap<String, TtyCondition>(this.extraTtys)), this.timeoutMillis, imageOpt);
    }

    private String getDescription() {
        return this.description == null ? null : this.description.toString();
    }

    protected void reportWarning(String message) {
        Msg.warn((Object)this, (Object)message);
    }

    protected void reportError(String message) {
        Msg.error((Object)this, (Object)message);
    }

    protected record Location(String fileName, int lineNo) {
        @Override
        public String toString() {
            return "%s:%d".formatted(this.fileName, this.lineNo);
        }
    }

    public record ScriptAttributes(String title, String description, List<String> menuPath, String menuGroup, String menuOrder, Icon icon, HelpLocation helpLocation, Map<String, LaunchParameter<?>> parameters, Map<String, TtyCondition> extraTtys, int timeoutMillis, LaunchParameter<?> imageOpt) {
    }

    protected static interface OptType<T>
    extends ValStr.Decoder<T> {
        public static OptType<?> parse(Location loc, String typeName, Map<String, UserType<?>> userEnums) throws ParseException {
            OptType<Object> type = BaseType.parseNoErr(typeName);
            if (type == null) {
                type = userEnums.get(typeName);
            }
            if (type == null) {
                throw new ParseException(loc, "%s: Invalid type %s".formatted(loc, typeName));
            }
            return type;
        }

        default public TypeAndDefault<T> withCastDefault(ValStr<Object> defaultValue) {
            return new TypeAndDefault(this, ValStr.cast(this.cls(), defaultValue));
        }

        public Class<T> cls();

        default public T decode(Location loc, String str) throws ParseException {
            try {
                return (T)this.decode(str);
            }
            catch (Exception e) {
                throw new ParseException(loc, "%s: %s".formatted(loc, e.getMessage()));
            }
        }

        public LaunchParameter<T> createParameter(String var1, String var2, String var3, boolean var4, ValStr<T> var5);
    }

    public static class ParseException
    extends Exception {
        private Location loc;

        public ParseException(Location loc, String message) {
            super(message);
            this.loc = loc;
        }

        public Location getLocation() {
            return this.loc;
        }
    }

    protected static interface BaseType<T>
    extends OptType<T> {
        public static final BaseType<String> STRING = new BaseType<String>(){

            @Override
            public Class<String> cls() {
                return String.class;
            }

            public String decode(String str) {
                return str;
            }
        };
        public static final BaseType<BigInteger> INT = new BaseType<BigInteger>(){

            @Override
            public Class<BigInteger> cls() {
                return BigInteger.class;
            }

            public BigInteger decode(String str) {
                try {
                    return NumericUtilities.decodeBigInteger((String)str);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid int %s. Prefixes 0x, 0b, and 0 (octal) are allowed.".formatted(str));
                }
            }
        };
        public static final BaseType<Boolean> BOOL = new BaseType<Boolean>(){

            @Override
            public Class<Boolean> cls() {
                return Boolean.class;
            }

            public Boolean decode(String str) {
                Boolean result;
                switch (str.trim().toLowerCase()) {
                    case "true": {
                        Boolean bl = true;
                        break;
                    }
                    case "false": {
                        Boolean bl = false;
                        break;
                    }
                    default: {
                        Boolean bl = result = null;
                    }
                }
                if (result == null) {
                    throw new IllegalArgumentException("Invalid bool for %s: %s. Only true or false is allowed.".formatted(ScriptAttributesParser.AT_ENV, str));
                }
                return result;
            }
        };
        public static final BaseType<Path> PATH = new BaseType<Path>(){

            @Override
            public Class<Path> cls() {
                return Path.class;
            }

            public Path decode(String str) {
                return Paths.get(str, new String[0]);
            }
        };
        public static final BaseType<AutoConfigState.PathIsDir> DIR = new BaseType<AutoConfigState.PathIsDir>(){

            @Override
            public Class<AutoConfigState.PathIsDir> cls() {
                return AutoConfigState.PathIsDir.class;
            }

            public AutoConfigState.PathIsDir decode(String str) {
                return new AutoConfigState.PathIsDir(Paths.get(str, new String[0]));
            }
        };
        public static final BaseType<AutoConfigState.PathIsFile> FILE = new BaseType<AutoConfigState.PathIsFile>(){

            @Override
            public Class<AutoConfigState.PathIsFile> cls() {
                return AutoConfigState.PathIsFile.class;
            }

            public AutoConfigState.PathIsFile decode(String str) {
                return new AutoConfigState.PathIsFile(Paths.get(str, new String[0]));
            }
        };

        public static BaseType<?> parseNoErr(String typeName) {
            return switch (typeName) {
                case "str" -> STRING;
                case "int" -> INT;
                case "bool" -> BOOL;
                case "path" -> PATH;
                case "dir" -> DIR;
                case "file" -> FILE;
                default -> null;
            };
        }

        public static BaseType<?> parse(Location loc, String typeName) throws ParseException {
            BaseType<?> type = BaseType.parseNoErr(typeName);
            if (type == null) {
                throw new ParseException(loc, "%s: Invalid base type %s".formatted(loc, typeName));
            }
            return type;
        }

        default public UserType<T> withCastChoices(List<?> choices) {
            return new UserType<Object>(this, choices.stream().map(this.cls()::cast).toList());
        }

        default public UserType<T> withChoices(List<T> choices) {
            return new UserType<T>(this, choices);
        }

        @Override
        default public LaunchParameter<T> createParameter(String name, String display, String description, boolean required, ValStr<T> defaultValue) {
            return LaunchParameter.create(this.cls(), (String)name, (String)display, (String)description, (boolean)required, defaultValue, (ValStr.Decoder)this);
        }
    }

    protected record UserType<T>(BaseType<T> base, List<T> choices) implements OptType<T>
    {
        @Override
        public Class<T> cls() {
            return this.base.cls();
        }

        public T decode(String str) {
            return (T)this.base.decode(str);
        }

        @Override
        public LaunchParameter<T> createParameter(String name, String display, String description, boolean required, ValStr<T> defaultValue) {
            return LaunchParameter.choices(this.cls(), (String)name, (String)display, (String)description, this.choices, defaultValue);
        }
    }

    protected record TypeAndDefault<T>(OptType<T> type, ValStr<T> defaultValue) {
        public static TypeAndDefault<?> parse(Location loc, String typeName, String defaultString, Map<String, UserType<?>> userEnums) throws ParseException {
            OptType<?> tac = OptType.parse(loc, typeName, userEnums);
            Object value = tac.decode(loc, defaultString);
            return tac.withCastDefault((ValStr<Object>)new ValStr(value, defaultString));
        }

        public LaunchParameter<T> createParameter(String name, String display, String description, boolean required) {
            return this.type.createParameter(name, display, description, required, this.defaultValue);
        }
    }

    static enum ConstTtyCondition implements TtyCondition
    {
        ALWAYS{

            @Override
            public boolean isActive(Map<String, ValStr<?>> args) {
                return true;
            }
        };

    }

    public static interface TtyCondition {
        public boolean isActive(Map<String, ValStr<?>> var1);
    }

    record BoolTtyCondition(LaunchParameter<Boolean> param) implements TtyCondition
    {
        @Override
        public boolean isActive(Map<String, ValStr<?>> args) {
            ValStr valStr = this.param.get(args);
            return valStr != null && (Boolean)valStr.val() != false;
        }
    }

    record EqualsTtyCondition(LaunchParameter<?> param, Object value) implements TtyCondition
    {
        @Override
        public boolean isActive(Map<String, ValStr<?>> args) {
            ValStr valStr = this.param.get(args);
            return Objects.equals(valStr == null ? null : valStr.val(), this.value);
        }
    }
}

