/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.sprites;

import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.BlastParticle;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.SmokeParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.sprites.MissileSprite;
import com.shatteredpixel.shatteredpixeldungeon.sprites.MobSprite;
import com.watabou.noosa.MovieClip;
import com.watabou.noosa.TextureFilm;
import com.watabou.noosa.Visual;
import com.watabou.utils.Callback;

public class TankSprite
extends MobSprite {
    int cellToAttack;

    public TankSprite() {
        this.texture("sprites/tank.png");
        TextureFilm frames = new TextureFilm(this.texture, 25, 15);
        this.idle = new MovieClip.Animation(10, true);
        this.idle.frames(frames, 0, 1);
        this.run = new MovieClip.Animation(10, true);
        this.run.frames(frames, 2, 3);
        this.attack = new MovieClip.Animation(30, false);
        this.attack.frames(frames, 4, 5, 6, 5, 6);
        this.zap = new MovieClip.Animation(15, false);
        this.zap.frames(frames, 7, 8, 8, 9, 9, 8, 8, 0, 0);
        this.die = new MovieClip.Animation(40, false);
        this.die.frames(frames, 10, 10, 11, 11, 11, 12, 12, 12, 12, 13, 13, 13, 13, 14, 14, 14, 15, 15, 16, 16);
        this.play(this.idle);
    }

    @Override
    public void zap(int cell) {
        this.cellToAttack = cell;
        this.turnTo(this.ch.pos, cell);
        this.play(this.zap);
        CellEmitter.get(this.ch.pos).burst(SmokeParticle.FACTORY, 2);
        CellEmitter.center(this.ch.pos).burst(BlastParticle.FACTORY, 4);
        ((MissileSprite)this.parent.recycle(MissileSprite.class)).reset((Visual)this, this.cellToAttack, (Item)new TankShot(), new Callback(){

            @Override
            public void call() {
                TankSprite.this.ch.onAttackComplete();
            }
        });
    }

    @Override
    public void die() {
        this.emitter().burst(Speck.factory(7), 8);
        super.die();
    }

    @Override
    public void onComplete(MovieClip.Animation anim) {
        if (anim == this.zap) {
            this.idle();
        }
        super.onComplete(anim);
    }

    @Override
    public int blood() {
        return -120;
    }

    public class TankShot
    extends Item {
        public TankShot() {
            this.image = ItemSpriteSheet.ROCKET;
        }
    }
}

