/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.sprites;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.BlastParticle;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.ShaftParticle;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.SmokeParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.DriedRose;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.sprites.MissileSprite;
import com.shatteredpixel.shatteredpixeldungeon.sprites.MobSprite;
import com.watabou.glwrap.Blending;
import com.watabou.noosa.MovieClip;
import com.watabou.noosa.TextureFilm;
import com.watabou.noosa.Visual;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Callback;
import com.watabou.utils.Random;

public class GhostSprite
extends MobSprite {
    private int cellToAttack;

    public GhostSprite() {
        this.texture("sprites/ghost.png");
        TextureFilm frames = new TextureFilm(this.texture, 14, 15);
        this.idle = new MovieClip.Animation(5, true);
        this.idle.frames(frames, 0, 1);
        this.run = new MovieClip.Animation(10, true);
        this.run.frames(frames, 0, 1);
        this.attack = new MovieClip.Animation(10, false);
        this.attack.frames(frames, 0, 2, 3);
        this.zap = this.attack.clone();
        this.die = new MovieClip.Animation(8, false);
        this.die.frames(frames, 0, 4, 5, 6, 7);
        this.play(this.idle);
    }

    @Override
    public void draw() {
        Blending.setLightMode();
        super.draw();
        Blending.setNormalMode();
    }

    @Override
    public void attack(int cell) {
        if (!Dungeon.level.adjacent(cell, this.ch.pos) && ((DriedRose.GhostHero)this.ch).isGun) {
            this.cellToAttack = cell;
            this.turnTo(this.ch.pos, cell);
            this.play(this.zap);
        } else {
            super.attack(cell);
        }
    }

    @Override
    public void onComplete(MovieClip.Animation anim) {
        if (anim == this.zap) {
            this.idle();
            CellEmitter.get(this.ch.pos).burst(SmokeParticle.FACTORY, 2);
            CellEmitter.center(this.ch.pos).burst(BlastParticle.FACTORY, 2);
            Sample.INSTANCE.play("sounds/hit_crush.mp3", 1.0f, Random.Float(0.33f, 0.66f));
            ((MissileSprite)this.parent.recycle(MissileSprite.class)).reset((Visual)this, this.cellToAttack, (Item)new GhostShot(), new Callback(){

                @Override
                public void call() {
                    GhostSprite.this.ch.onAttackComplete();
                }
            });
        } else {
            super.onComplete(anim);
        }
    }

    @Override
    public void die() {
        super.die();
        this.emitter().start(ShaftParticle.FACTORY, 0.3f, 4);
        this.emitter().start(Speck.factory(2), 0.2f, 3);
    }

    @Override
    public int blood() {
        return 0xFFFFFF;
    }

    public class GhostShot
    extends Item {
        public GhostShot() {
            this.image = ItemSpriteSheet.SPIRIT_BULLET;
        }
    }
}

