/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.scenes;

import com.shatteredpixel.shatteredpixeldungeon.SPDSettings;
import com.shatteredpixel.shatteredpixeldungeon.SeedFinder;
import com.shatteredpixel.shatteredpixeldungeon.ShatteredPixelDungeon;
import com.shatteredpixel.shatteredpixeldungeon.messages.Languages;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.HeroSelectScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.TitleScene;
import com.shatteredpixel.shatteredpixeldungeon.ui.Archs;
import com.shatteredpixel.shatteredpixeldungeon.ui.ExitButton;
import com.shatteredpixel.shatteredpixeldungeon.ui.RenderedTextBlock;
import com.shatteredpixel.shatteredpixeldungeon.ui.ScrollPane;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndTextInput;
import com.watabou.noosa.Camera;
import com.watabou.noosa.ColorBlock;
import com.watabou.noosa.Group;
import com.watabou.noosa.ui.Component;
import java.util.Arrays;

public class SeedFindScene
extends PixelScene {
    @Override
    public void create() {
        super.create();
        float colWidth = 120.0f;
        final float fullWidth = 120.0f * (float)(SeedFindScene.landscape() ? 2 : 1);
        final int w = Camera.main.width;
        final int h = Camera.main.height;
        Archs archs = new Archs();
        archs.setSize(w, h);
        this.add(archs);
        this.add(new ColorBlock(w, h, -2013265920));
        final ScrollPane list = new ScrollPane(new Component());
        this.add(list);
        Component content = list.content();
        content.clear();
        ShatteredPixelDungeon.scene().addToFront(new WndTextInput(Messages.get(this, "title", new Object[0]), Messages.get(this, "body", new Object[0]), Messages.get(this, "initial_value", new Object[0]), 1000, true, Messages.get(this, "find", new Object[0]), Messages.get(HeroSelectScene.class, "custom_seed_clear", new Object[0])){

            @Override
            public void onSelect(boolean positive, String text) {
                int floor = 31;
                boolean floorOption = false;
                String up_to_floor = Messages.lang() == Languages.KOREAN ? "\uce35\uae4c\uc9c0" : "floor end";
                String strFloor = Messages.lang() == Languages.KOREAN ? "\uce35" : "floor";
                if (text.contains(up_to_floor)) {
                    floorOption = true;
                    String fl = text.split(strFloor)[0].trim();
                    try {
                        floor = Integer.parseInt(fl);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (positive && text != "") {
                    String[] itemList = floorOption ? Arrays.copyOfRange(text.split("\n"), 1, text.split("\n").length) : text.split("\n");
                    Component content = list.content();
                    content.clear();
                    CreditsBlock txt = new CreditsBlock(true, 0xFFFF44, new SeedFinder().findSeed(itemList, floor));
                    txt.setRect(((float)Camera.main.width - 120.0f) / 2.0f, 12.0f, 120.0f, 0.0f);
                    content.add(txt);
                    content.setSize(fullWidth, txt.bottom() + 10.0f);
                    list.setRect(0.0f, 0.0f, w, h);
                    list.scrollTo(0.0f, 0.0f);
                } else {
                    SPDSettings.customSeed("");
                    ShatteredPixelDungeon.switchNoFade(TitleScene.class);
                }
            }
        });
        ExitButton btnExit = new ExitButton();
        btnExit.setPos((float)Camera.main.width - btnExit.width(), 0.0f);
        this.add(btnExit);
    }

    @Override
    protected void onBackPressed() {
        ShatteredPixelDungeon.switchScene(TitleScene.class);
    }

    private void addLine(float y, Group content) {
        ColorBlock line = new ColorBlock(Camera.main.width, 1.0f, -13421773);
        line.y = y;
        content.add(line);
    }

    public static class CreditsBlock
    extends Component {
        boolean large;
        RenderedTextBlock body;

        public CreditsBlock(boolean large, int highlight, String body) {
            this.large = large;
            this.body = PixelScene.renderTextBlock(body, 6);
            if (highlight != -1) {
                this.body.setHightlighting(true, highlight);
            }
            if (large) {
                this.body.align(2);
            }
            this.add(this.body);
        }

        @Override
        protected void layout() {
            super.layout();
            float topY = this.top();
            if (this.large) {
                this.body.maxWidth((int)this.width());
                this.body.setPos(this.x + (this.width() - this.body.width()) / 2.0f, topY);
            } else {
                this.body.maxWidth((int)this.width());
                this.body.setPos(this.x, topY += 1.0f);
            }
            this.height = Math.max(this.height, (topY += this.body.height()) - this.top());
        }
    }
}

