/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.plants;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroSubClass;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfTeleportation;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.plants.Plant;
import com.shatteredpixel.shatteredpixeldungeon.scenes.InterlevelScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.watabou.noosa.Game;

public class Fadeleaf
extends Plant {
    public Fadeleaf() {
        this.image = 10;
        this.seedClass = Seed.class;
    }

    @Override
    public void activate(Char ch) {
        if (ch instanceof Hero) {
            ((Hero)ch).curAction = null;
            if ((((Hero)ch).subClass == HeroSubClass.WARDEN || Dungeon.hero.pointsInTalent(Talent.FARMER) == 3) && Dungeon.interfloorTeleportAllowed()) {
                Level.beforeTransition();
                InterlevelScene.mode = InterlevelScene.Mode.RETURN;
                InterlevelScene.returnDepth = Math.max(1, Dungeon.depth - 1);
                InterlevelScene.returnBranch = 0;
                InterlevelScene.returnPos = -2;
                Game.switchScene(InterlevelScene.class);
            } else {
                ScrollOfTeleportation.teleportChar(ch, Fadeleaf.class);
            }
        } else if (ch instanceof Mob && !ch.properties().contains((Object)Char.Property.IMMOVABLE)) {
            ScrollOfTeleportation.teleportChar(ch, Fadeleaf.class);
        }
        if (Dungeon.level.heroFOV[this.pos]) {
            CellEmitter.get(this.pos).start(Speck.factory(2), 0.2f, 3);
        }
    }

    public static class Seed
    extends Plant.Seed {
        public Seed() {
            this.image = ItemSpriteSheet.SEED_FADELEAF;
            this.plantClass = Fadeleaf.class;
        }
    }
}

